/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.GetServiceResponse;
import com.google.common.base.Strings;

public class GetServiceRequest
extends HttpRequest {
    private final String serviceName;
    private String qualifier;

    public GetServiceRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public GetServiceRequest setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    @Override
    public String getPath() {
        if (Strings.isNullOrEmpty((String)this.qualifier)) {
            return String.format("/%s/services/%s", "2016-08-15", this.serviceName);
        }
        return String.format("/%s/services/%s.%s", "2016-08-15", this.serviceName, this.qualifier);
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    public Class<GetServiceResponse> getResponseClass() {
        return GetServiceResponse.class;
    }
}

