/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.GetTriggerResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class GetTriggerRequest
extends HttpRequest {
    private final String serviceName;
    private final String functionName;
    private final String triggerName;

    public GetTriggerRequest(String serviceName, String functionName, String triggerName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
        this.triggerName = triggerName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions/%s/triggers/%s", "2016-08-15", this.serviceName, this.functionName, this.triggerName);
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.triggerName)) {
            throw new ClientException("Trigger name cannot be blank");
        }
    }

    public Class<GetTriggerResponse> getResponseClass() {
        return GetTriggerResponse.class;
    }
}

