/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.auth.AcsURLEncoder;
import com.aliyuncs.fc.model.HttpAuthType;
import com.aliyuncs.fc.model.HttpMethod;
import com.aliyuncs.fc.request.InvokeFunctionRequest;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class HttpInvokeFunctionRequest
extends InvokeFunctionRequest {
    private final String path;
    private final HttpMethod method;
    private final HttpAuthType authType;
    private final Map<String, String> queryParams = new HashMap<String, String>();

    public HttpInvokeFunctionRequest(String serviceName, String functionName, HttpAuthType authType, HttpMethod method) {
        this(serviceName, functionName, authType, method, "");
    }

    public HttpInvokeFunctionRequest(String serviceName, String functionName, HttpAuthType authType, HttpMethod method, String path) {
        super(serviceName, functionName);
        this.setInvocationType("http");
        try {
            if (path != null) {
                URIBuilder uriBuilder = new URIBuilder(path);
                path = AcsURLEncoder.decode(uriBuilder.getPath());
                for (NameValuePair pair : uriBuilder.getQueryParams()) {
                    this.addQuery(AcsURLEncoder.decode(pair.getName()), AcsURLEncoder.decode(pair.getValue()));
                }
            }
            this.path = path == null ? "" : (path.startsWith("/") ? path.substring(1) : path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.authType = authType;
        this.method = method;
    }

    public void addQuery(String name, String value) {
        if (value == null) {
            value = "";
        }
        this.queryParams.put(name, value);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public String getPath() {
        if (Strings.isNullOrEmpty((String)this.getQualifier())) {
            return String.format("/%s/proxy/%s/%s/%s", "2016-08-15", this.getServiceName(), this.getFunctionName(), this.path);
        }
        return String.format("/%s/proxy/%s.%s/%s/%s", "2016-08-15", this.getServiceName(), this.getQualifier(), this.getFunctionName(), this.path);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpAuthType getAuthType() {
        return this.authType;
    }
}

