/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.InvokeFunctionResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class InvokeFunctionRequest
extends HttpRequest {
    private final String serviceName;
    private final String functionName;
    private String invocationType;
    private String logType;
    private String qualifier;
    private byte[] payload;

    public InvokeFunctionRequest(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getInvocationType() {
        return this.invocationType;
    }

    public InvokeFunctionRequest setInvocationType(String invocationType) {
        this.invocationType = invocationType;
        return this;
    }

    public String getLogType() {
        return this.logType;
    }

    public InvokeFunctionRequest setLogType(String logType) {
        this.logType = logType;
        return this;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public InvokeFunctionRequest setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public String getPath() {
        if (Strings.isNullOrEmpty((String)this.qualifier)) {
            return String.format("/%s/services/%s/functions/%s/invocations", "2016-08-15", this.serviceName, this.functionName);
        }
        return String.format("/%s/services/%s.%s/functions/%s/invocations", "2016-08-15", this.serviceName, this.qualifier, this.functionName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (!Strings.isNullOrEmpty((String)this.invocationType) && !"http".equalsIgnoreCase(this.invocationType)) {
            this.headers.put("X-Fc-Invocation-Type", this.invocationType);
        }
        if (!Strings.isNullOrEmpty((String)this.logType)) {
            this.headers.put("X-Fc-Log-Type", this.logType);
        }
        return this.headers;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    @Override
    public byte[] getPayload() {
        if (this.payload == null || this.payload.length <= 0) {
            return null;
        }
        return this.payload;
    }

    public InvokeFunctionRequest setPayload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public Class<InvokeFunctionResponse> getResponseClass() {
        return InvokeFunctionResponse.class;
    }
}

