/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.ListRequestUrlHelper;
import com.aliyuncs.fc.response.ListAliasesResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class ListAliasesRequest
extends HttpRequest {
    private final String serviceName;
    private String prefix;
    private String startKey;
    private String nextToken;
    private Integer limit;

    public ListAliasesRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ListAliasesRequest setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public ListAliasesRequest setStartKey(String startKey) {
        this.startKey = startKey;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAliasesRequest setNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ListAliasesRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return ListRequestUrlHelper.buildParams(this.prefix, this.startKey, this.nextToken, this.limit);
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/aliases", "2016-08-15", this.serviceName);
    }

    public Class<ListAliasesResponse> getResponseClass() {
        return ListAliasesResponse.class;
    }
}

