/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.ListFunctionAsyncConfigsResponse;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;

public class ListFunctionAsyncConfigsRequest
extends HttpRequest {
    private String serviceName;
    private String functionName;
    private String nextToken;
    private Integer limit;

    public ListFunctionAsyncConfigsRequest(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFunctionAsyncConfigsRequest setNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ListFunctionAsyncConfigsRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public Map<String, String> getQueryParams() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.limit != null) {
            queryParams.put("limit", this.limit.toString());
        }
        if (this.nextToken != null) {
            queryParams.put("nextToken", this.nextToken);
        }
        return queryParams;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions/%s/async-invoke-configs", "2016-08-15", this.serviceName, this.functionName);
    }

    public Class<ListFunctionAsyncConfigsResponse> getResponseClass() {
        return ListFunctionAsyncConfigsResponse.class;
    }
}

