/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.ListRequestUrlHelper;
import com.aliyuncs.fc.response.ListFunctionsResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class ListFunctionsRequest
extends HttpRequest {
    private final String serviceName;
    private String prefix;
    private String startKey;
    private String nextToken;
    private Integer limit;
    private String qualifier;

    public ListFunctionsRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ListFunctionsRequest setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public ListFunctionsRequest setStartKey(String startKey) {
        this.startKey = startKey;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFunctionsRequest setNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ListFunctionsRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public ListFunctionsRequest setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    @Override
    public String getPath() {
        if (Strings.isNullOrEmpty((String)this.qualifier)) {
            return String.format("/%s/services/%s/functions", "2016-08-15", this.serviceName);
        }
        return String.format("/%s/services/%s.%s/functions", "2016-08-15", this.serviceName, this.qualifier);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return ListRequestUrlHelper.buildParams(this.prefix, this.startKey, this.nextToken, this.limit);
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    public Class<ListFunctionsResponse> getResponseClass() {
        return ListFunctionsResponse.class;
    }
}

