/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.ListRequestUrlHelper;
import com.aliyuncs.fc.response.ListTriggersResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class ListTriggersRequest
extends HttpRequest {
    private final String serviceName;
    private final String functionName;
    private String prefix;
    private String startKey;
    private String nextToken;
    private Integer limit;

    public ListTriggersRequest(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public ListTriggersRequest setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ListTriggersRequest setStartKey(String startKey) {
        this.startKey = startKey;
        return this;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public ListTriggersRequest setNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTriggersRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return ListRequestUrlHelper.buildParams(this.prefix, this.startKey, this.nextToken, this.limit);
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions/%s/triggers", "2016-08-15", this.serviceName, this.functionName);
    }

    public Class<ListTriggersResponse> getResponseClass() {
        return ListTriggersResponse.class;
    }
}

