/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.ListRequestUrlHelper;
import com.aliyuncs.fc.response.ListVersionsResponse;
import com.google.common.base.Strings;
import java.util.Map;

public class ListVersionsRequest
extends HttpRequest {
    public static final String LIST_DIRECTION_BACKWARD = "BACKWARD";
    public static final String LIST_DIRECTION_FORWARD = "FORWARD";
    private final String serviceName;
    private String startKey;
    private String nextToken;
    private Integer limit;
    private String direction;

    public ListVersionsRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public ListVersionsRequest setStartKey(String startKey) {
        this.startKey = startKey;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListVersionsRequest setNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ListVersionsRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public String getDirection() {
        return this.direction;
    }

    public ListVersionsRequest setDirection(String direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return ListRequestUrlHelper.buildListVersionParams(this.startKey, this.nextToken, this.limit, this.direction);
    }

    @Override
    public byte[] getPayload() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/versions", "2016-08-15", this.serviceName);
    }

    public Class<ListVersionsResponse> getResponseClass() {
        return ListVersionsResponse.class;
    }
}

