/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.PublishVersionResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class PublishVersionRequest
extends HttpRequest {
    private final transient String serviceName;
    private transient String ifMatch;
    @SerializedName(value="description")
    private String description;

    public PublishVersionRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getDescription() {
        return this.description;
    }

    public PublishVersionRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public PublishVersionRequest setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/versions", "2016-08-15", this.serviceName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (!Strings.isNullOrEmpty((String)this.ifMatch)) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    public Class<PublishVersionResponse> getResponseClass() {
        return PublishVersionResponse.class;
    }
}

