/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.AsyncConfig;
import com.aliyuncs.fc.response.PutFunctionAsyncConfigResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import java.util.Map;

public class PutFunctionAsyncConfigRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String qualifier;
    private final transient String functionName;
    private AsyncConfig asyncConfig;

    public PutFunctionAsyncConfigRequest(String serviceName, String qualifier, String functionName) {
        this.serviceName = serviceName;
        this.qualifier = qualifier;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public PutFunctionAsyncConfigRequest setAsyncConfig(AsyncConfig config) {
        this.asyncConfig = config;
        return this;
    }

    public AsyncConfig getAsyncConfig() {
        return this.asyncConfig;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this.asyncConfig).getBytes();
    }

    @Override
    public String getPath() {
        if (this.qualifier.isEmpty()) {
            return String.format("/%s/services/%s/functions/%s/async-invoke-config", "2016-08-15", this.serviceName, this.functionName);
        }
        return String.format("/%s/services/%s.%s/functions/%s/async-invoke-config", "2016-08-15", this.serviceName, this.qualifier, this.functionName);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    public Class<PutFunctionAsyncConfigResponse> getResponseClass() {
        return PutFunctionAsyncConfigResponse.class;
    }
}

