/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.PutProvisionConfigResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class PutProvisionConfigRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String qualifier;
    private final transient String functionName;
    private transient String ifMatch;
    @SerializedName(value="target")
    private Integer target;

    public PutProvisionConfigRequest(String serviceName, String qualifier, String functionName) {
        this.serviceName = serviceName;
        this.qualifier = qualifier;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public PutProvisionConfigRequest setTarget(Integer target) {
        this.target = target;
        return this;
    }

    public Integer getTarget() {
        return this.target;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public PutProvisionConfigRequest setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s.%s/functions/%s/provision-config", "2016-08-15", this.serviceName, this.qualifier, this.functionName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.ifMatch != null && this.ifMatch.length() < 0) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.qualifier)) {
            throw new ClientException("Qualifier cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    public Class<PutProvisionConfigResponse> getResponseClass() {
        return PutProvisionConfigResponse.class;
    }
}

