/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.TagResourceResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class TagResourceRequest
extends HttpRequest {
    @SerializedName(value="resourceArn")
    private String resourceArn;
    @SerializedName(value="tags")
    private Map<String, String> tags;

    public TagResourceRequest() {
    }

    public TagResourceRequest(String resourceArn, Map<String, String> tags) {
        this.resourceArn = resourceArn;
        this.tags = tags;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public String getPath() {
        return String.format("/%s/tag", "2016-08-15");
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.resourceArn)) {
            throw new ClientException("resourceArn cannot be blank");
        }
        if (this.tags.isEmpty()) {
            throw new ClientException("tags cannot be empty");
        }
    }

    public Class<TagResourceResponse> getResponseClass() {
        return TagResourceResponse.class;
    }
}

