/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.UntagResourceResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;

public class UntagResourceRequest
extends HttpRequest {
    @SerializedName(value="resourceArn")
    private String resourceArn;
    @SerializedName(value="tagKeys")
    private String[] tagKeys;
    @SerializedName(value="all")
    private boolean all;

    public UntagResourceRequest() {
    }

    public UntagResourceRequest(boolean all, String resourceArn, String[] tagKeys) {
        this.all = all;
        this.resourceArn = resourceArn;
        this.tagKeys = tagKeys;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String[] getTagKeys() {
        return this.tagKeys;
    }

    public void setTagKeys(String[] tagKeys) {
        this.tagKeys = tagKeys;
    }

    @Override
    public String getPath() {
        return String.format("/%s/tag", "2016-08-15");
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.resourceArn)) {
            throw new ClientException("resourceArn cannot be blank");
        }
        if (this.tagKeys.length == 0 && !this.all) {
            throw new ClientException("At least 1 tag key is required if all=false");
        }
    }

    public Class<UntagResourceResponse> getResponseClass() {
        return UntagResourceResponse.class;
    }
}

