/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.UpdateAliasResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class UpdateAliasRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String aliasName;
    private transient String ifMatch;
    @SerializedName(value="versionId")
    private String versionId;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="additionalVersionWeight")
    private Map<String, Float> additionalVersionWeight;

    public UpdateAliasRequest(String serviceName, String aliasName) {
        this.serviceName = serviceName;
        this.aliasName = aliasName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public UpdateAliasRequest setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateAliasRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public Map<String, Float> getAdditionalVersionWeight() {
        return this.additionalVersionWeight;
    }

    public UpdateAliasRequest setAdditionalVersionWeight(Map<String, Float> additionalVersionWeight) {
        this.additionalVersionWeight = additionalVersionWeight;
        return this;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/aliases/%s", "2016-08-15", this.serviceName, this.aliasName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.ifMatch != null && this.ifMatch.length() < 0) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.aliasName)) {
            throw new ClientException("Alias name cannot be blank");
        }
    }

    public Class<UpdateAliasResponse> getResponseClass() {
        return UpdateAliasResponse.class;
    }
}

