/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.CertConfig;
import com.aliyuncs.fc.model.RouteConfig;
import com.aliyuncs.fc.response.UpdateCustomDomainResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class UpdateCustomDomainRequest
extends HttpRequest {
    private final transient String domainName;
    @SerializedName(value="protocol")
    private String protocol;
    @SerializedName(value="routeConfig")
    private RouteConfig routeConfig;
    @SerializedName(value="certConfig")
    private CertConfig certConfig;

    public UpdateCustomDomainRequest(String domainName, String protocol, RouteConfig routeConfig) {
        this.domainName = domainName;
        this.protocol = protocol;
        this.routeConfig = routeConfig;
    }

    public UpdateCustomDomainRequest(String domainName, String protocol, RouteConfig routeConfig, CertConfig certConfig) {
        this.domainName = domainName;
        this.protocol = protocol;
        this.routeConfig = routeConfig;
        this.certConfig = certConfig;
    }

    public UpdateCustomDomainRequest(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public UpdateCustomDomainRequest setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public RouteConfig getRouteConfig() {
        return this.routeConfig;
    }

    public UpdateCustomDomainRequest setRouteConfig(RouteConfig routeConfig) {
        this.routeConfig = routeConfig;
        return this;
    }

    public CertConfig getCertConfig() {
        return this.certConfig;
    }

    public void setCertConfig(CertConfig certConfig) {
        this.certConfig = certConfig;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public String getPath() {
        return String.format("/%s/custom-domains/%s", "2016-08-15", this.domainName);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.domainName)) {
            throw new ClientException("Domain name cannot be blank");
        }
    }

    public Class<UpdateCustomDomainResponse> getResponseClass() {
        return UpdateCustomDomainResponse.class;
    }
}

