/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.Code;
import com.aliyuncs.fc.model.CustomContainerConfig;
import com.aliyuncs.fc.response.UpdateFunctionResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class UpdateFunctionRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String functionName;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="runtime")
    private String runtime;
    @SerializedName(value="handler")
    private String handler;
    @SerializedName(value="initializer")
    private String initializer;
    @SerializedName(value="timeout")
    private Integer timeout;
    @SerializedName(value="initializationTimeout")
    private Integer initializationTimeout;
    @SerializedName(value="memorySize")
    private Integer memorySize;
    @SerializedName(value="code")
    private Code code;
    @SerializedName(value="environmentVariables")
    private Map<String, String> environmentVariables;
    @SerializedName(value="instanceConcurrency")
    private Integer instanceConcurrency;
    @SerializedName(value="instanceType")
    private String instanceType;
    @SerializedName(value="customContainerConfig")
    private CustomContainerConfig customContainerConfig;
    @SerializedName(value="caPort")
    private Integer caPort;
    private transient String ifMatch;

    public UpdateFunctionRequest(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateFunctionRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public UpdateFunctionRequest setRuntime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    public String getHandler() {
        return this.handler;
    }

    public UpdateFunctionRequest setHandler(String handler) {
        this.handler = handler;
        return this;
    }

    public UpdateFunctionRequest setInitializer(String initializer) {
        this.initializer = initializer;
        return this;
    }

    public String getInitializer() {
        return this.initializer;
    }

    public UpdateFunctionRequest setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public UpdateFunctionRequest setInitializationTimeout(Integer initializationTimeout) {
        this.initializationTimeout = initializationTimeout;
        return this;
    }

    public Integer getInitializationTimeout() {
        return this.initializationTimeout;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public UpdateFunctionRequest setMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
        return this;
    }

    public UpdateFunctionRequest setInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public UpdateFunctionRequest setCustomContainerConfig(CustomContainerConfig customContainerConfig) {
        this.customContainerConfig = customContainerConfig;
        return this;
    }

    public UpdateFunctionRequest setCAPort(Integer caPort) {
        this.caPort = caPort;
        return this;
    }

    public Integer getCAPort() {
        return this.caPort;
    }

    public Code getCode() {
        return this.code;
    }

    public UpdateFunctionRequest setCode(Code code) {
        this.code = code;
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public UpdateFunctionRequest setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions/%s", "2016-08-15", this.serviceName, this.functionName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.ifMatch != null && this.ifMatch.length() < 0) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
    }

    public Class<UpdateFunctionResponse> getResponseClass() {
        return UpdateFunctionResponse.class;
    }

    public Integer getInstanceConcurrency() {
        return this.instanceConcurrency;
    }

    public void setInstanceConcurrency(Integer instanceConcurrency) {
        this.instanceConcurrency = instanceConcurrency;
    }
}

