/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.model.LogConfig;
import com.aliyuncs.fc.model.NasConfig;
import com.aliyuncs.fc.model.TracingConfig;
import com.aliyuncs.fc.model.VpcConfig;
import com.aliyuncs.fc.response.UpdateServiceResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class UpdateServiceRequest
extends HttpRequest {
    private final transient String serviceName;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="role")
    private String role;
    @SerializedName(value="logConfig")
    private LogConfig logConfig;
    @SerializedName(value="vpcConfig")
    private VpcConfig vpcConfig;
    @SerializedName(value="internetAccess")
    private Boolean internetAccess;
    @SerializedName(value="nasConfig")
    private NasConfig nasConfig;
    @SerializedName(value="tracingConfig")
    private TracingConfig tracingConfig;
    private transient String ifMatch;

    public UpdateServiceRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getIfMatch() {
        return this.serviceName;
    }

    public UpdateServiceRequest setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateServiceRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public UpdateServiceRequest setRole(String role) {
        this.role = role;
        return this;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public UpdateServiceRequest setLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
        return this;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s", "2016-08-15", this.serviceName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.ifMatch != null && this.ifMatch.length() > 0) {
            this.headers.put("If-Match", this.getIfMatch());
        }
        return this.headers;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
    }

    public Class<UpdateServiceResponse> getResponseClass() {
        return UpdateServiceResponse.class;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public Boolean getInternetAccess() {
        return this.internetAccess;
    }

    public void setInternetAccess(Boolean internetAccess) {
        this.internetAccess = internetAccess;
    }

    public NasConfig getNasConfig() {
        return this.nasConfig;
    }

    public void setNasConfig(NasConfig nasConfig) {
        this.nasConfig = nasConfig;
    }

    public TracingConfig getTracingConfig() {
        return this.tracingConfig;
    }

    public void setTracingConfig(TracingConfig tracingConfig) {
        this.tracingConfig = tracingConfig;
    }
}

