/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.request;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.http.HttpRequest;
import com.aliyuncs.fc.response.UpdateTriggerResponse;
import com.aliyuncs.fc.utils.ParameterHelper;
import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class UpdateTriggerRequest
extends HttpRequest {
    private final transient String serviceName;
    private final transient String functionName;
    private final transient String triggerName;
    @SerializedName(value="invocationRole")
    private String invocationRole;
    @SerializedName(value="triggerConfig")
    private Object triggerConfig;
    @SerializedName(value="qualifier")
    private String qualifier;
    private transient String ifMatch;

    public UpdateTriggerRequest(String serviveName, String functionName, String triggerName) {
        this.serviceName = serviveName;
        this.functionName = functionName;
        this.triggerName = triggerName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public UpdateTriggerRequest setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public Object getTriggerConfig() {
        return this.triggerConfig;
    }

    public UpdateTriggerRequest setTriggerConfig(Object triggerConfig) {
        this.triggerConfig = triggerConfig;
        return this;
    }

    public String getInvocationRole() {
        return this.invocationRole;
    }

    public UpdateTriggerRequest setInvocationRole(String invocationRole) {
        this.invocationRole = invocationRole;
        return this;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public UpdateTriggerRequest setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    @Override
    public String getPath() {
        return String.format("/%s/services/%s/functions/%s/triggers/%s", "2016-08-15", this.serviceName, this.functionName, this.triggerName);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (!Strings.isNullOrEmpty((String)this.ifMatch)) {
            this.headers.put("If-Match", this.ifMatch);
        }
        return this.headers;
    }

    @Override
    public byte[] getPayload() {
        return ParameterHelper.ObjectToJson(this).getBytes();
    }

    @Override
    public Map<String, String> getQueryParams() {
        return null;
    }

    @Override
    public void validate() throws ClientException {
        if (Strings.isNullOrEmpty((String)this.serviceName)) {
            throw new ClientException("Service name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.functionName)) {
            throw new ClientException("Function name cannot be blank");
        }
        if (Strings.isNullOrEmpty((String)this.triggerName)) {
            throw new ClientException("Trigger name cannot be blank");
        }
    }

    public Class<UpdateTriggerResponse> getResponseClass() {
        return UpdateTriggerResponse.class;
    }
}

