/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.response;

import com.aliyuncs.fc.exceptions.ClientException;
import com.aliyuncs.fc.exceptions.ServerException;
import com.aliyuncs.fc.http.HttpResponse;
import com.aliyuncs.fc.model.FunctionMetadata;
import com.aliyuncs.fc.model.ServiceMetadata;
import com.aliyuncs.fc.response.CreateFunctionResponse;
import com.aliyuncs.fc.response.CreateServiceResponse;
import com.aliyuncs.fc.response.CreateVpcBindingResponse;
import com.aliyuncs.fc.response.DeleteFunctionResponse;
import com.aliyuncs.fc.response.DeleteServiceResponse;
import com.aliyuncs.fc.response.DeleteVpcBindingResponse;
import com.aliyuncs.fc.response.GetFunctionResponse;
import com.aliyuncs.fc.response.GetServiceResponse;
import com.aliyuncs.fc.response.InvokeFunctionResponse;
import com.aliyuncs.fc.response.ListFunctionsResponse;
import com.aliyuncs.fc.response.ListServicesResponse;
import com.aliyuncs.fc.response.ListVpcBindingsResponse;
import com.aliyuncs.fc.response.UpdateFunctionResponse;
import com.aliyuncs.fc.response.UpdateServiceResponse;
import com.aliyuncs.fc.utils.Base64Helper;
import com.aliyuncs.fc.utils.FcUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;

public class ResponseFactory {
    private static final Gson GSON = new Gson();

    public static CreateFunctionResponse genCreateFunctionResponse(HttpResponse response) throws ClientException, ServerException {
        FunctionMetadata functionMetadata = (FunctionMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), FunctionMetadata.class);
        CreateFunctionResponse createFunctionResponse = new CreateFunctionResponse();
        createFunctionResponse.setFunctionMetadata(functionMetadata);
        createFunctionResponse.setHeaders(response.getHeaders());
        createFunctionResponse.setContent(response.getContent());
        createFunctionResponse.setStatus(response.getStatus());
        return createFunctionResponse;
    }

    public static InvokeFunctionResponse genInvokeFunctionResponse(HttpResponse response) throws ClientException, ServerException {
        InvokeFunctionResponse invokeFunctionResponse = new InvokeFunctionResponse();
        invokeFunctionResponse.setContent(response.getContent());
        invokeFunctionResponse.setPayload(response.getContent());
        invokeFunctionResponse.setHeaders(response.getHeaders());
        invokeFunctionResponse.setStatus(response.getStatus());
        Map<String, String> headers = response.getHeaders();
        if (headers != null && headers.containsKey("X-Fc-Log-Result")) {
            try {
                String logResult = Base64Helper.decode(headers.get("X-Fc-Log-Result"), "utf-8");
                invokeFunctionResponse.setLogResult(logResult);
            }
            catch (IOException e) {
                throw new ClientException(e);
            }
        }
        return invokeFunctionResponse;
    }

    public static DeleteFunctionResponse genDeleteFunctionResponse(HttpResponse response) throws ClientException, ServerException {
        DeleteFunctionResponse deleteFunctionResponse = new DeleteFunctionResponse();
        deleteFunctionResponse.setHeaders(response.getHeaders());
        deleteFunctionResponse.setStatus(response.getStatus());
        return deleteFunctionResponse;
    }

    public static UpdateFunctionResponse genUpdateFunctionResponse(HttpResponse response) throws ClientException, ServerException {
        FunctionMetadata functionMetadata = (FunctionMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), FunctionMetadata.class);
        UpdateFunctionResponse updateFunctionResponse = new UpdateFunctionResponse();
        updateFunctionResponse.setFunctionMetadata(functionMetadata);
        updateFunctionResponse.setHeaders(response.getHeaders());
        updateFunctionResponse.setContent(response.getContent());
        updateFunctionResponse.setStatus(response.getStatus());
        return updateFunctionResponse;
    }

    public static ListFunctionsResponse genListFunctionResponse(HttpResponse response) throws ClientException, ServerException {
        ListFunctionsResponse listFunctionsResponse = (ListFunctionsResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListFunctionsResponse.class);
        listFunctionsResponse.setHeaders(response.getHeaders());
        listFunctionsResponse.setContent(response.getContent());
        listFunctionsResponse.setStatus(response.getStatus());
        return listFunctionsResponse;
    }

    public static GetFunctionResponse genGetFunctionResponse(HttpResponse response) throws ClientException, ServerException {
        FunctionMetadata functionMetadata = (FunctionMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), FunctionMetadata.class);
        GetFunctionResponse getFunctionResponse = new GetFunctionResponse();
        getFunctionResponse.setFunctionMetadata(functionMetadata);
        getFunctionResponse.setHeaders(response.getHeaders());
        getFunctionResponse.setContent(response.getContent());
        getFunctionResponse.setStatus(response.getStatus());
        return getFunctionResponse;
    }

    public static CreateServiceResponse genCreateServiceResponse(HttpResponse response) throws ClientException, ServerException {
        ServiceMetadata serviceMetadata = (ServiceMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ServiceMetadata.class);
        CreateServiceResponse createServiceResponse = new CreateServiceResponse();
        createServiceResponse.setServiceMetadata(serviceMetadata);
        createServiceResponse.setHeaders(response.getHeaders());
        createServiceResponse.setContent(response.getContent());
        createServiceResponse.setStatus(response.getStatus());
        return createServiceResponse;
    }

    public static CreateVpcBindingResponse genCreateVpcBindingResponse(HttpResponse response) throws ClientException, ServerException {
        CreateVpcBindingResponse createVpcBindingResponse = new CreateVpcBindingResponse();
        createVpcBindingResponse.setHeaders(response.getHeaders());
        createVpcBindingResponse.setStatus(response.getStatus());
        createVpcBindingResponse.setContent(response.getContent());
        return createVpcBindingResponse;
    }

    public static UpdateServiceResponse genUpdateServiceResponse(HttpResponse response) throws ClientException, ServerException {
        ServiceMetadata serviceMetadata = (ServiceMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ServiceMetadata.class);
        UpdateServiceResponse updateServiceResponse = new UpdateServiceResponse();
        updateServiceResponse.setServiceMetadata(serviceMetadata);
        updateServiceResponse.setHeaders(response.getHeaders());
        updateServiceResponse.setContent(response.getContent());
        updateServiceResponse.setStatus(response.getStatus());
        return updateServiceResponse;
    }

    public static ListVpcBindingsResponse genListVpcBindingsResponse(HttpResponse response) throws ClientException, ServerException {
        ListVpcBindingsResponse listVpcBindingsResponse = (ListVpcBindingsResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListVpcBindingsResponse.class);
        listVpcBindingsResponse.setHeaders(response.getHeaders());
        listVpcBindingsResponse.setContent(response.getContent());
        listVpcBindingsResponse.setStatus(response.getStatus());
        return listVpcBindingsResponse;
    }

    public static ListServicesResponse genListServiceResponse(HttpResponse response) throws ClientException, ServerException {
        ListServicesResponse listServicesResponse = (ListServicesResponse)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ListServicesResponse.class);
        listServicesResponse.setHeaders(response.getHeaders());
        listServicesResponse.setContent(response.getContent());
        listServicesResponse.setStatus(response.getStatus());
        return listServicesResponse;
    }

    public static GetServiceResponse genGetServiceResponse(HttpResponse response) throws ClientException, ServerException {
        ServiceMetadata serviceMetadata = (ServiceMetadata)GSON.fromJson(FcUtil.toDefaultCharset(response.getContent()), ServiceMetadata.class);
        GetServiceResponse getServiceResponse = new GetServiceResponse();
        getServiceResponse.setServiceMetadata(serviceMetadata);
        getServiceResponse.setHeaders(response.getHeaders());
        getServiceResponse.setContent(response.getContent());
        getServiceResponse.setStatus(response.getStatus());
        return getServiceResponse;
    }

    public static DeleteVpcBindingResponse genDeleteVpcBindingResponse(HttpResponse response) throws ClientException, ServerException {
        DeleteVpcBindingResponse deleteVpcBindingResponse = new DeleteVpcBindingResponse();
        deleteVpcBindingResponse.setHeaders(response.getHeaders());
        deleteVpcBindingResponse.setContent(response.getContent());
        deleteVpcBindingResponse.setStatus(response.getStatus());
        return deleteVpcBindingResponse;
    }

    public static DeleteServiceResponse genDeleteServiceResponse(HttpResponse response) throws ClientException, ServerException {
        DeleteServiceResponse deleteServiceResponse = new DeleteServiceResponse();
        deleteServiceResponse.setHeaders(response.getHeaders());
        deleteServiceResponse.setStatus(response.getStatus());
        return deleteServiceResponse;
    }
}

