/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.fc.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void zipDir(File dir, String zipName) throws IOException {
        Preconditions.checkArgument((dir != null ? 1 : 0) != 0, (Object)("dir `" + dir + "` cannot be null"));
        Preconditions.checkArgument((boolean)dir.isDirectory(), (Object)("dir `" + dir + "` must be a directory"));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zipName) ? 1 : 0) != 0, (Object)"zipName cannot be blank");
        ArrayList<String> fileNames = new ArrayList<String>();
        ZipUtils.getFileNames(dir, fileNames);
        FileOutputStream fos = new FileOutputStream(zipName);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (String filePath : fileNames) {
            int len;
            ZipEntry ze = new ZipEntry(filePath.substring(dir.getAbsolutePath().length() + 1, filePath.length()));
            zos.putNextEntry(ze);
            FileInputStream fis = new FileInputStream(filePath);
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
            fis.close();
        }
        zos.close();
        fos.close();
    }

    private static void getFileNames(File dir, List<String> fileNames) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                fileNames.add(file.getAbsolutePath());
                continue;
            }
            ZipUtils.getFileNames(file, fileNames);
        }
    }
}

