/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.ocr.model.v20191230;

import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.ocr.Endpoint;

/**
 * @author auto create
 * @version 
 */
public class RecognizeCharacterRequest extends RpcAcsRequest<RecognizeCharacterResponse> {
	   

	private Boolean outputProbability;

	private String imageURL;

	private Integer minHeight;
	public RecognizeCharacterRequest() {
		super("ocr", "2019-12-30", "RecognizeCharacter", "ocr");
		setMethod(MethodType.POST);
		try {
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointMap").set(this, Endpoint.endpointMap);
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointRegional").set(this, Endpoint.endpointRegionalType);
		} catch (Exception e) {}
	}

	public Boolean getOutputProbability() {
		return this.outputProbability;
	}

	public void setOutputProbability(Boolean outputProbability) {
		this.outputProbability = outputProbability;
		if(outputProbability != null){
			putBodyParameter("OutputProbability", outputProbability.toString());
		}
	}

	public String getImageURL() {
		return this.imageURL;
	}

	public void setImageURL(String imageURL) {
		this.imageURL = imageURL;
		if(imageURL != null){
			putBodyParameter("ImageURL", imageURL);
		}
	}

	public Integer getMinHeight() {
		return this.minHeight;
	}

	public void setMinHeight(Integer minHeight) {
		this.minHeight = minHeight;
		if(minHeight != null){
			putBodyParameter("MinHeight", minHeight.toString());
		}
	}

	@Override
	public Class<RecognizeCharacterResponse> getResponseClass() {
		return RecognizeCharacterResponse.class;
	}

}
