/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.vpc.transform.v20160428;

import java.util.ArrayList;
import java.util.List;

import com.aliyuncs.vpc.model.v20160428.DescribeVpnConnectionLogsResponse;
import com.aliyuncs.transform.UnmarshallerContext;


public class DescribeVpnConnectionLogsResponseUnmarshaller {

	public static DescribeVpnConnectionLogsResponse unmarshall(DescribeVpnConnectionLogsResponse describeVpnConnectionLogsResponse, UnmarshallerContext context) {
		
		describeVpnConnectionLogsResponse.setRequestId(context.stringValue("DescribeVpnConnectionLogsResponse.RequestId"));
		describeVpnConnectionLogsResponse.setCount(context.integerValue("DescribeVpnConnectionLogsResponse.Count"));
		describeVpnConnectionLogsResponse.setIsCompleted(context.booleanValue("DescribeVpnConnectionLogsResponse.IsCompleted"));
		describeVpnConnectionLogsResponse.setPageNumber(context.integerValue("DescribeVpnConnectionLogsResponse.PageNumber"));
		describeVpnConnectionLogsResponse.setPageSize(context.integerValue("DescribeVpnConnectionLogsResponse.PageSize"));

		List<String> data = new ArrayList<String>();
		for (int i = 0; i < context.lengthValue("DescribeVpnConnectionLogsResponse.Data.Length"); i++) {
			data.add(context.stringValue("DescribeVpnConnectionLogsResponse.Data["+ i +"]"));
		}
		describeVpnConnectionLogsResponse.setData(data);
	 
	 	return describeVpnConnectionLogsResponse;
	}
}