/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.vpc.model.v20160428;

import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.vpc.Endpoint;

/**
 * @author auto create
 * @version 
 */
public class CreateVirtualPhysicalConnectionRequest extends RpcAcsRequest<CreateVirtualPhysicalConnectionResponse> {
	   

	private Long vpconnAliUid;

	private String orderMode;

	private Long vlanId;

	private String vpconnUidResourceGroupId;

	private String description;

	private String spec;

	private String resourceGroupId;

	private Boolean dryRun;

	private String token;

	private String physicalConnectionId;

	private String name;
	public CreateVirtualPhysicalConnectionRequest() {
		super("Vpc", "2016-04-28", "CreateVirtualPhysicalConnection", "vpc");
		setMethod(MethodType.POST);
		try {
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointMap").set(this, Endpoint.endpointMap);
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointRegional").set(this, Endpoint.endpointRegionalType);
		} catch (Exception e) {}
	}

	public Long getVpconnAliUid() {
		return this.vpconnAliUid;
	}

	public void setVpconnAliUid(Long vpconnAliUid) {
		this.vpconnAliUid = vpconnAliUid;
		if(vpconnAliUid != null){
			putQueryParameter("VpconnAliUid", vpconnAliUid.toString());
		}
	}

	public String getOrderMode() {
		return this.orderMode;
	}

	public void setOrderMode(String orderMode) {
		this.orderMode = orderMode;
		if(orderMode != null){
			putQueryParameter("OrderMode", orderMode);
		}
	}

	public Long getVlanId() {
		return this.vlanId;
	}

	public void setVlanId(Long vlanId) {
		this.vlanId = vlanId;
		if(vlanId != null){
			putQueryParameter("VlanId", vlanId.toString());
		}
	}

	public String getVpconnUidResourceGroupId() {
		return this.vpconnUidResourceGroupId;
	}

	public void setVpconnUidResourceGroupId(String vpconnUidResourceGroupId) {
		this.vpconnUidResourceGroupId = vpconnUidResourceGroupId;
		if(vpconnUidResourceGroupId != null){
			putQueryParameter("VpconnUidResourceGroupId", vpconnUidResourceGroupId);
		}
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
		if(description != null){
			putQueryParameter("Description", description);
		}
	}

	public String getSpec() {
		return this.spec;
	}

	public void setSpec(String spec) {
		this.spec = spec;
		if(spec != null){
			putQueryParameter("Spec", spec);
		}
	}

	public String getResourceGroupId() {
		return this.resourceGroupId;
	}

	public void setResourceGroupId(String resourceGroupId) {
		this.resourceGroupId = resourceGroupId;
		if(resourceGroupId != null){
			putQueryParameter("ResourceGroupId", resourceGroupId);
		}
	}

	public Boolean getDryRun() {
		return this.dryRun;
	}

	public void setDryRun(Boolean dryRun) {
		this.dryRun = dryRun;
		if(dryRun != null){
			putQueryParameter("DryRun", dryRun.toString());
		}
	}

	public String getToken() {
		return this.token;
	}

	public void setToken(String token) {
		this.token = token;
		if(token != null){
			putQueryParameter("Token", token);
		}
	}

	public String getPhysicalConnectionId() {
		return this.physicalConnectionId;
	}

	public void setPhysicalConnectionId(String physicalConnectionId) {
		this.physicalConnectionId = physicalConnectionId;
		if(physicalConnectionId != null){
			putQueryParameter("PhysicalConnectionId", physicalConnectionId);
		}
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
		if(name != null){
			putQueryParameter("Name", name);
		}
	}

	@Override
	public Class<CreateVirtualPhysicalConnectionResponse> getResponseClass() {
		return CreateVirtualPhysicalConnectionResponse.class;
	}

}
