/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.vpc.model.v20160428;

import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.vpc.Endpoint;

/**
 * @author auto create
 * @version 
 */
public class DeleteIpsecServerRequest extends RpcAcsRequest<DeleteIpsecServerResponse> {
	   

	private String dryRun;

	private String clientToken;

	private String ipsecServerId;
	public DeleteIpsecServerRequest() {
		super("Vpc", "2016-04-28", "DeleteIpsecServer", "vpc");
		setMethod(MethodType.POST);
		try {
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointMap").set(this, Endpoint.endpointMap);
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointRegional").set(this, Endpoint.endpointRegionalType);
		} catch (Exception e) {}
	}

	public String getDryRun() {
		return this.dryRun;
	}

	public void setDryRun(String dryRun) {
		this.dryRun = dryRun;
		if(dryRun != null){
			putQueryParameter("DryRun", dryRun);
		}
	}

	public String getClientToken() {
		return this.clientToken;
	}

	public void setClientToken(String clientToken) {
		this.clientToken = clientToken;
		if(clientToken != null){
			putQueryParameter("ClientToken", clientToken);
		}
	}

	public String getIpsecServerId() {
		return this.ipsecServerId;
	}

	public void setIpsecServerId(String ipsecServerId) {
		this.ipsecServerId = ipsecServerId;
		if(ipsecServerId != null){
			putQueryParameter("IpsecServerId", ipsecServerId);
		}
	}

	@Override
	public Class<DeleteIpsecServerResponse> getResponseClass() {
		return DeleteIpsecServerResponse.class;
	}

}
