/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.vpc.model.v20160428;

import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.vpc.Endpoint;

/**
 * @author auto create
 * @version 
 */
public class ModifyFlowLogAttributeRequest extends RpcAcsRequest<ModifyFlowLogAttributeResponse> {
	   

	private Long resourceOwnerId;

	private String description;

	private String resourceOwnerAccount;

	private String ownerAccount;

	private Integer aggregationInterval;

	private Long ownerId;

	private String flowLogId;

	private String flowLogName;
	public ModifyFlowLogAttributeRequest() {
		super("Vpc", "2016-04-28", "ModifyFlowLogAttribute", "vpc");
		setMethod(MethodType.POST);
		try {
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointMap").set(this, Endpoint.endpointMap);
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointRegional").set(this, Endpoint.endpointRegionalType);
		} catch (Exception e) {}
	}

	public Long getResourceOwnerId() {
		return this.resourceOwnerId;
	}

	public void setResourceOwnerId(Long resourceOwnerId) {
		this.resourceOwnerId = resourceOwnerId;
		if(resourceOwnerId != null){
			putQueryParameter("ResourceOwnerId", resourceOwnerId.toString());
		}
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
		if(description != null){
			putQueryParameter("Description", description);
		}
	}

	public String getResourceOwnerAccount() {
		return this.resourceOwnerAccount;
	}

	public void setResourceOwnerAccount(String resourceOwnerAccount) {
		this.resourceOwnerAccount = resourceOwnerAccount;
		if(resourceOwnerAccount != null){
			putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
		}
	}

	public String getOwnerAccount() {
		return this.ownerAccount;
	}

	public void setOwnerAccount(String ownerAccount) {
		this.ownerAccount = ownerAccount;
		if(ownerAccount != null){
			putQueryParameter("OwnerAccount", ownerAccount);
		}
	}

	public Integer getAggregationInterval() {
		return this.aggregationInterval;
	}

	public void setAggregationInterval(Integer aggregationInterval) {
		this.aggregationInterval = aggregationInterval;
		if(aggregationInterval != null){
			putQueryParameter("AggregationInterval", aggregationInterval.toString());
		}
	}

	public Long getOwnerId() {
		return this.ownerId;
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
		if(ownerId != null){
			putQueryParameter("OwnerId", ownerId.toString());
		}
	}

	public String getFlowLogId() {
		return this.flowLogId;
	}

	public void setFlowLogId(String flowLogId) {
		this.flowLogId = flowLogId;
		if(flowLogId != null){
			putQueryParameter("FlowLogId", flowLogId);
		}
	}

	public String getFlowLogName() {
		return this.flowLogName;
	}

	public void setFlowLogName(String flowLogName) {
		this.flowLogName = flowLogName;
		if(flowLogName != null){
			putQueryParameter("FlowLogName", flowLogName);
		}
	}

	@Override
	public Class<ModifyFlowLogAttributeResponse> getResponseClass() {
		return ModifyFlowLogAttributeResponse.class;
	}

}
