/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.vpc.model.v20160428;

import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.vpc.Endpoint;

/**
 * @author auto create
 * @version 
 */
public class ModifyNatIpCidrAttributeRequest extends RpcAcsRequest<ModifyNatIpCidrAttributeResponse> {
	   

	private String natIpCidrDescription;

	private Long resourceOwnerId;

	private String clientToken;

	private String natGatewayId;

	private Boolean dryRun;

	private String resourceOwnerAccount;

	private String ownerAccount;

	private String natIpCidrName;

	private Long ownerId;

	private String natIpCidr;
	public ModifyNatIpCidrAttributeRequest() {
		super("Vpc", "2016-04-28", "ModifyNatIpCidrAttribute", "vpc");
		setMethod(MethodType.POST);
		try {
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointMap").set(this, Endpoint.endpointMap);
			com.aliyuncs.AcsRequest.class.getDeclaredField("productEndpointRegional").set(this, Endpoint.endpointRegionalType);
		} catch (Exception e) {}
	}

	public String getNatIpCidrDescription() {
		return this.natIpCidrDescription;
	}

	public void setNatIpCidrDescription(String natIpCidrDescription) {
		this.natIpCidrDescription = natIpCidrDescription;
		if(natIpCidrDescription != null){
			putQueryParameter("NatIpCidrDescription", natIpCidrDescription);
		}
	}

	public Long getResourceOwnerId() {
		return this.resourceOwnerId;
	}

	public void setResourceOwnerId(Long resourceOwnerId) {
		this.resourceOwnerId = resourceOwnerId;
		if(resourceOwnerId != null){
			putQueryParameter("ResourceOwnerId", resourceOwnerId.toString());
		}
	}

	public String getClientToken() {
		return this.clientToken;
	}

	public void setClientToken(String clientToken) {
		this.clientToken = clientToken;
		if(clientToken != null){
			putQueryParameter("ClientToken", clientToken);
		}
	}

	public String getNatGatewayId() {
		return this.natGatewayId;
	}

	public void setNatGatewayId(String natGatewayId) {
		this.natGatewayId = natGatewayId;
		if(natGatewayId != null){
			putQueryParameter("NatGatewayId", natGatewayId);
		}
	}

	public Boolean getDryRun() {
		return this.dryRun;
	}

	public void setDryRun(Boolean dryRun) {
		this.dryRun = dryRun;
		if(dryRun != null){
			putQueryParameter("DryRun", dryRun.toString());
		}
	}

	public String getResourceOwnerAccount() {
		return this.resourceOwnerAccount;
	}

	public void setResourceOwnerAccount(String resourceOwnerAccount) {
		this.resourceOwnerAccount = resourceOwnerAccount;
		if(resourceOwnerAccount != null){
			putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
		}
	}

	public String getOwnerAccount() {
		return this.ownerAccount;
	}

	public void setOwnerAccount(String ownerAccount) {
		this.ownerAccount = ownerAccount;
		if(ownerAccount != null){
			putQueryParameter("OwnerAccount", ownerAccount);
		}
	}

	public String getNatIpCidrName() {
		return this.natIpCidrName;
	}

	public void setNatIpCidrName(String natIpCidrName) {
		this.natIpCidrName = natIpCidrName;
		if(natIpCidrName != null){
			putQueryParameter("NatIpCidrName", natIpCidrName);
		}
	}

	public Long getOwnerId() {
		return this.ownerId;
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
		if(ownerId != null){
			putQueryParameter("OwnerId", ownerId.toString());
		}
	}

	public String getNatIpCidr() {
		return this.natIpCidr;
	}

	public void setNatIpCidr(String natIpCidr) {
		this.natIpCidr = natIpCidr;
		if(natIpCidr != null){
			putQueryParameter("NatIpCidr", natIpCidr);
		}
	}

	@Override
	public Class<ModifyNatIpCidrAttributeResponse> getResponseClass() {
		return ModifyNatIpCidrAttributeResponse.class;
	}

}
