package darabonba.core;

import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.core.http.HttpClient;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.client.DefaultClientBuilder;
import darabonba.core.client.IClientBuilder;
import darabonba.core.policy.UserAgentPolicy;
import darabonba.core.policy.retry.RetryPolicy;
import darabonba.core.utils.CommonUtil;

import java.util.Optional;

public abstract class TeaClientBuilder<BuilderT extends IClientBuilder<BuilderT, ClientT>, ClientT> extends DefaultClientBuilder<BuilderT, ClientT> {

    protected abstract String serviceName();

    protected TeaClientBuilder() {
        super();
    }

    public BuilderT httpClient(HttpClient httpClient) {
        this.clientConfiguration.setOption(ClientOption.ASYNC_HTTP_CLIENT, httpClient);
        return (BuilderT) this;
    }

    @Override
    protected final ClientConfiguration mergeChildDefaults(ClientConfiguration configuration) {
        ClientConfiguration config = mergeServiceDefaults(configuration);
        return config.merge(ClientConfiguration.create()
                //TODO add more option
                .setOption(ClientOption.SERVICE_NAME, serviceName()));
    }

    protected ClientConfiguration mergeServiceDefaults(ClientConfiguration configuration) {
        return configuration;
    }

    @Override
    protected final ClientConfiguration finalizeChildConfiguration(ClientConfiguration configuration) {
        configuration = finalizeServiceConfiguration(configuration);
        //TODO
        return configuration.copy()
                .setOption(ClientOption.REGION, resolveRegion(configuration))
                .setOption(ClientOption.ENDPOINT, resolveEndpoint(configuration))
                .setOption(ClientOption.CREDENTIALS_PROVIDER, resolveCredentials(configuration))
                .setOption(ClientOption.RETRY_POLICY, resolveRetryPolicy(configuration))
                .setOption(ClientOption.USER_AGENT, resolveUserAgent(configuration));
    }

    protected ClientConfiguration finalizeServiceConfiguration(ClientConfiguration configuration) {
        return configuration;
    }

    private String resolveRegion(ClientConfiguration config) {
        return Optional.ofNullable(config.option(ClientOption.REGION))
                .orElseGet(() -> regionFromConfig(config));
    }

    private String regionFromConfig(ClientConfiguration config) {
        return null;
    }

    private String resolveEndpointType(ClientConfiguration config) {
        return Optional.ofNullable(config.option(ClientOption.ENDPOINT_TYPE))
                .orElseGet(() -> endpointTypeFromConfig(config));
    }

    private String endpointTypeFromConfig(ClientConfiguration config) {
        return null;
    }

    private String resolveEndpoint(ClientConfiguration config) {
        return Optional.ofNullable(config.option(ClientOption.ENDPOINT))
                .orElseGet(() -> endpointFromConfig(config));
    }

    private String endpointFromConfig(ClientConfiguration config) {
        return null;
    }

    private ICredentialProvider resolveCredentials(ClientConfiguration config) {
        return Optional.ofNullable(config.option(ClientOption.CREDENTIALS_PROVIDER))
                .orElseGet(() -> credentialsFromConfig(config));
    }

    private ICredentialProvider credentialsFromConfig(ClientConfiguration config) {
        //TODO
        return null;
    }

    private RetryPolicy resolveRetryPolicy(ClientConfiguration config) {
        return Optional.ofNullable(config.option(ClientOption.RETRY_POLICY))
                .orElseGet(() -> retryPolicyFromConfig(config));
    }

    private RetryPolicy retryPolicyFromConfig(ClientConfiguration config) {
        return null;
    }

    private String resolveUserAgent(ClientConfiguration config) {
        return Optional.ofNullable(config.option(ClientOption.USER_AGENT))
                .orElseGet(() -> userAgentDefault(config));
    }

    private String userAgentDefault(ClientConfiguration config) {
        StringBuilder userAgentBuilder = new StringBuilder();
        userAgentBuilder.append(UserAgentPolicy.toUserAgentString(serviceName()));
        String gatewayService = config.option(ClientOption.USER_AGENT_SERVICE_SUFFIX);
        if (!CommonUtil.isUnset(gatewayService)) {
            userAgentBuilder.append(" ")
                    .append("GatewayService")
                    .append("/")
                    .append(gatewayService);
        }
        String userService = config.option(ClientOption.USER_AGENT_USER_SUFFIX);
        if (!CommonUtil.isUnset(userService)) {
            userAgentBuilder.append(" ")
                    .append("UserService")
                    .append("/")
                    .append(userService);
        }
        return userAgentBuilder.toString();
    }
}
