package darabonba.core.async;

import darabonba.core.ResponseBytes;
import darabonba.core.TeaResponseHandler;
import org.reactivestreams.Publisher;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;

public interface AsyncResponseHandler<ResponseT, ResultT> extends TeaResponseHandler {
    void onStream(Publisher<ByteBuffer> publisher);
    ResultT transform(ResponseT response);


    static <ResponseT> AsyncResponseHandler<ResponseT, ResponseT> toFile(Path path) {
        return new FileAsyncResponseHandler<>(path);
    }

    static <ResponseT> AsyncResponseHandler<ResponseT, ResponseT> toFile(File file) {
        return toFile(file.toPath());
    }

    static <ResponseT> AsyncResponseHandler<ResponseT, ResponseBytes<ResponseT>> toBytes() {
        return new ByteArrayAsyncResponseHandler<>();
    }
}
