package darabonba.core.async;

import com.aliyun.core.utils.BinaryUtils;
import darabonba.core.ResponseBytes;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

import static com.aliyun.core.utils.FunctionalUtils.invokeSafely;

public final class ByteArrayAsyncResponseHandler<ResponseT> implements AsyncResponseHandler<ResponseT, ResponseBytes<ResponseT>> {
    private BaosSubscriber subscriber;

    @Override
    public void onStream(Publisher<ByteBuffer> publisher) {
        this.subscriber = new BaosSubscriber();
        publisher.subscribe(this.subscriber);
    }

    @Override
    public ResponseBytes<ResponseT> transform(ResponseT response) {
        return ResponseBytes.fromByteArrayUnsafe(response, this.subscriber.baos.toByteArray());
    }

    static class BaosSubscriber implements Subscriber<ByteBuffer> {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private Subscription subscription;

        BaosSubscriber() {
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.subscription != null) {
                s.cancel();
                return;
            }
            this.subscription = s;
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            invokeSafely(() -> baos.write(BinaryUtils.copyBytesFrom(byteBuffer)));
            subscription.request(1);
        }

        @Override
        public void onError(Throwable throwable) {
            baos = null;
        }

        @Override
        public void onComplete() {
        }
    }
}
