package darabonba.core.client;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.Copyable;
import com.aliyun.core.utils.SdkAutoCloseable;

public final class ClientConfiguration implements SdkAutoCloseable, Copyable {

    private final AttributeMap attributes;

    private ClientConfiguration(AttributeMap attributes) {
        this.attributes = attributes;
    }

    public static ClientConfiguration create() {
        return new ClientConfiguration(AttributeMap.empty());
    }

    public <T> T option(ClientOption<T> option) {
        return attributes.get(option);
    }

    public <T> ClientConfiguration setOption(ClientOption<T> option, T value) {
        this.attributes.put(option, value);
        return this;
    }

    public ClientConfiguration merge(ClientConfiguration configuration) {
        return new ClientConfiguration(attributes.merge(configuration.attributes));
    }

    public AttributeMap getAttributes() {
        return attributes;
    }

    @Override
    public ClientConfiguration copy() {
        return new ClientConfiguration(this.attributes.copy());
    }

    @Override
    public void close() {
        this.attributes.close();
    }
}
