/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.internal.async;

import darabonba.core.async.AsyncRequestBody;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ByteArrayAsyncRequestBody
implements AsyncRequestBody {
    private final byte[] bytes;

    public ByteArrayAsyncRequestBody(byte[] bytes) {
        this.bytes = (byte[])bytes.clone();
    }

    @Override
    public Optional<Long> contentLength() {
        return Optional.of(Long.valueOf(this.bytes.length));
    }

    @Override
    public Optional<String> contentType() {
        return Optional.empty();
    }

    public void subscribe(final Subscriber<? super ByteBuffer> s) {
        if (s == null) {
            throw new NullPointerException("Subscription is null.");
        }
        try {
            s.onSubscribe(new Subscription(){
                private boolean done = false;

                public void request(long n) {
                    if (this.done) {
                        return;
                    }
                    if (n > 0L) {
                        this.done = true;
                        s.onNext((Object)ByteBuffer.wrap(ByteArrayAsyncRequestBody.this.bytes));
                        s.onComplete();
                    } else {
                        s.onError((Throwable)new IllegalArgumentException("non-positive requests are not allowed!"));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cancel() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.done) {
                            this.done = true;
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            new IllegalStateException(ex).printStackTrace();
        }
    }
}

