/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.sse;

import com.aliyun.core.utils.StringUtils;
import darabonba.core.exception.TeaException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Event {
    private static final Pattern pattern = Pattern.compile("(?<name>[^:]*):?( ?(?<value>.*))?");
    private final String data;
    private final String event;
    private final String id;
    private final int retry;

    private Event(Builder builder) {
        this.data = builder.data;
        this.event = builder.event;
        this.id = builder.id;
        this.retry = builder.retry;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getData() {
        return this.data;
    }

    public String getEvent() {
        return this.event;
    }

    public String getId() {
        return this.id;
    }

    public int getRetry() {
        return this.retry;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Event parse(String raw) {
        Event event = Event.builder().build();
        for (String line : raw.split("\n")) {
            Matcher m = pattern.matcher(line);
            if (m.find()) {
                String name = m.group("name");
                if ("".equals(name)) continue;
                String value = m.group("value");
                if ("data".equals(name)) {
                    event = !StringUtils.isEmpty((CharSequence)event.getData()) ? event.toBuilder().data(event.getData() + "\n" + value).build() : event.toBuilder().data(value).build();
                }
                if ("event".equals(name)) {
                    event = event.toBuilder().event(value).build();
                }
                if ("id".equals(name)) {
                    event = event.toBuilder().id(value).build();
                }
                if (!"retry".equals(name)) continue;
                event = event.toBuilder().retry(Integer.parseInt(value)).build();
                continue;
            }
            throw new TeaException("NO DATA.");
        }
        return event;
    }

    public String toString() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("id: ", this.id);
        fieldMap.put("event: ", this.event);
        fieldMap.put("retry: ", this.retry);
        fieldMap.put("data: ", this.data);
        return StringUtils.toAliString((String)"Event", fieldMap);
    }

    public static final class Builder {
        private String data;
        private String event;
        private String id;
        private int retry;

        private Builder() {
        }

        private Builder(Event event) {
            this.data = event.data;
            this.event = event.event;
            this.id = event.id;
            this.retry = event.retry;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder event(String event) {
            this.event = event;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder retry(int retry) {
            this.retry = retry;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

