package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.*;
import com.aliyun.datahub.client.model.GetSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.OpenSubscriptionSessionResult;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.SubscriptionOffset;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

//点位操作示例
public class OffsetExample {
    private static DatahubClient datahubClient;
    private static String subId;
    private static RecordSchema recordSchema;

    private static String shardId;
    private static List<String> shardIds;


    public static void init() {
        // 创建DataHubClient实例
        datahubClient = DatahubClientBuilder.newBuilder()
                .setDatahubConfig(
                        new DatahubConfig(Constant.endpoint,
                                // 是否开启二进制传输，服务端2.12版本开始支持
                                new AliyunAccount(Constant.accessId, Constant.accessKey), true))
                .build();

        //创建一个subscription
        //CreateSubscriptionResult createSubscriptionResult = datahubClient.createSubscription(Constant.projectName, Constant.topicName, "subscription comment");
        //subId = createSubscriptionResult.getSubId();

        // config your subId
        subId = "";

        recordSchema = datahubClient.getTopic(Constant.projectName, Constant.topicName).getRecordSchema();

        shardId = "";
        shardIds = new ArrayList<String>();
        shardIds.add(shardId);
    }

    //初始化点位
    public static void openSubscriptionSession() {
        try {
            OpenSubscriptionSessionResult openSubscriptionSessionResult = datahubClient.openSubscriptionSession(Constant.projectName, Constant.topicName, subId, shardIds);
            SubscriptionOffset subscriptionOffset = openSubscriptionSessionResult.getOffsets().get(shardId);
            System.out.println(subscriptionOffset.getSessionId() + "\t"
                    + subscriptionOffset.getVersionId() + "\t"
                    + subscriptionOffset.getSequence());
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic or subscription not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    //获取点位
    public static void getSubscriptionOffset() {
        try {
            GetSubscriptionOffsetResult getSubscriptionOffsetResult = datahubClient.getSubscriptionOffset(Constant.projectName, Constant.topicName, subId, shardIds);
            SubscriptionOffset subscriptionOffset = getSubscriptionOffsetResult.getOffsets().get(shardId);
            System.out.println(subscriptionOffset.getVersionId() + "\t"
                    + subscriptionOffset.getSequence());
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic or subscription not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    //提交点位
    public static void commitSubscriptionOffset(int maxRetry) {
        for (int i =0 ;i <maxRetry;i++){
            try {
                OpenSubscriptionSessionResult openSubscriptionSessionResult = datahubClient.openSubscriptionSession(Constant.projectName, Constant.topicName, subId, shardIds);
                SubscriptionOffset subscriptionOffset = openSubscriptionSessionResult.getOffsets().get(shardId);

                //这里仅仅测试提交，完整过程请参考点位消费样例
                subscriptionOffset.setSequence(10);
                subscriptionOffset.setTimestamp(100);
                Map<String, SubscriptionOffset> offsets = new HashMap<String, SubscriptionOffset>();
                offsets.put(shardId, subscriptionOffset);

                // 提交点位
                datahubClient.commitSubscriptionOffset(Constant.projectName, Constant.topicName, subId, offsets);
            } catch (InvalidParameterException e) {
                // invalid parameter, please check your parameter
                e.printStackTrace();
                throw e;
            } catch (AuthorizationFailureException e) {
                // AK error, please check your accessId and accessKey
                e.printStackTrace();
                throw e;
            } catch (ResourceNotFoundException e) {
                // project or topic or subscription not found
                e.printStackTrace();
                throw e;
            } catch (SubscriptionOffsetResetException e) {
                // offset is reset elsewhere
                e.printStackTrace();
                throw e;
            } catch (SubscriptionSessionInvalidException e) {
                // offset is open elsewhere
                e.printStackTrace();
                throw e;
            } catch (SubscriptionOfflineException e) {
                //subscription is offline
                e.printStackTrace();
                throw e;
            } catch (LimitExceededException e){
                // limit exceed, retry
                e.printStackTrace();
            }
            catch (DatahubClientException e) {
                // other error, retry
                e.printStackTrace();
            }
        }
    }

    //重置点位一般重置到某个时间点，
    public static void resetSubscriptionOffset() {
        //选择想要重置点位到的时间，并转换为时间戳
        String time = "2019-07-09 10:00:00";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long timestamp = 0L;
        try {
            Date date = simpleDateFormat.parse(time);
            timestamp = date.getTime();//获取时间的时间戳
            //System.out.println(timestamp);
        } catch (ParseException e) {
            System.exit(1);
        }

        try {
            SubscriptionOffset offset = new SubscriptionOffset();
            offset.setTimestamp(timestamp);

            Map<String, SubscriptionOffset> offsets = new HashMap<String, SubscriptionOffset>();
            for (String shardId : shardIds) {
                offsets.put(shardId, offset);
            }
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic or subscription not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) {
        init();

//        openSubscriptionSession();
        //getSubscriptionOffset();
//        commitSubscriptionOffset();
        resetSubscriptionOffset();
    }

}
