package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.*;
import com.aliyun.datahub.client.model.GetProjectResult;
import com.aliyun.datahub.client.model.ListProjectResult;

public class ProjectExample {
    private static DatahubClient datahubClient;


    public static void init() {
        // 创建DataHubClient实例
        datahubClient = DatahubClientBuilder.newBuilder()
                .setDatahubConfig(
                        new DatahubConfig(Constant.endpoint,
                                // 是否开启二进制传输，服务端2.12版本开始支持
                                new AliyunAccount(Constant.accessId, Constant.accessKey), true))
                .build();


    }


    public static void createProject() {
        try {
            datahubClient.createProject(Constant.projectName, Constant.projectComment);
            System.out.println("create project successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceAlreadyExistException e) {
            System.out.println("project already exists, create project successful");
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void deleteProject() {
        try {
            datahubClient.deleteProject(Constant.projectName);
            System.out.println("delete project successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            System.out.println("project already exists, create project successful");
        } catch (NoPermissionException e) {
            //delete failed,may be project has topic
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateProject() {
        try {
            String newComment = "new project comment";
            datahubClient.updateProject(Constant.projectName, newComment);
            System.out.println("update project successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            //project not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void listProject() {
        try {
            ListProjectResult listProjectResult = datahubClient.listProject();
            if (listProjectResult.getProjectNames().size() > 0) {
                for (String pName : listProjectResult.getProjectNames()) {
                    System.out.println(pName);
                }
            }
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void getProject() {

        try {
            GetProjectResult getProjectResult = datahubClient.getProject(Constant.projectName);
            System.out.println(getProjectResult.getCreateTime() + "\t"
                    + getProjectResult.getLastModifyTime() + "\t"
                    + getProjectResult.getComment());
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            //project not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }

    }

    public static void main(String[] args) {
        init();

        createProject();

        listProject();

        updateProject();

        getProject();

        deleteProject();

    }

}
