package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.model.*;


public class SubscriptionExample {
    private static DatahubClient datahubClient;
    private static String subId;


    public static void init() {
        // 创建DataHubClient实例
        datahubClient = DatahubClientBuilder.newBuilder()
                .setDatahubConfig(
                        new DatahubConfig(Constant.endpoint,
                                // 是否开启二进制传输，服务端2.12版本开始支持
                                new AliyunAccount(Constant.accessId, Constant.accessKey), true))
                .build();

        //创建一个subscription
        //CreateSubscriptionResult createSubscriptionResult = datahubClient.createSubscription(Constant.projectName, Constant.topicName, "subscription comment");
        //subId = createSubscriptionResult.getSubId();

        // config your subId
        subId = "";
    }


    public static void createSubscription() {
        try {
            CreateSubscriptionResult createSubscriptionResult = datahubClient.createSubscription(Constant.projectName, Constant.topicName, Constant.subscribtionComment);
            System.out.println("create subscription successful");
            System.out.println(createSubscriptionResult.getSubId());
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void deleteSubscription() {
        try {
            datahubClient.deleteSubscription(Constant.projectName, Constant.topicName, subId);
            System.out.println("delete subscription successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic or subscription not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateSubscription() {
        try {
            String newComment = "new subscription comment";
            datahubClient.updateSubscription(Constant.projectName, Constant.topicName, subId, newComment);
            System.out.println("update subscription successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic or subscription not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void listSubscription() {
        try {
            ListSubscriptionResult listSubscriptionResult = datahubClient.listSubscription(Constant.projectName, Constant.topicName, Constant.pageNum, Constant.pageSize);
            if (listSubscriptionResult.getSubscriptions().size() > 0) {
                System.out.println(listSubscriptionResult.getTotalCount());
                System.out.println(listSubscriptionResult.getSubscriptions().size());
                for (SubscriptionEntry entry : listSubscriptionResult.getSubscriptions()) {
                    System.out.println(entry.getSubId() + "\t"
                            + entry.getState() + "\t"
                            + entry.getType() + "\t"
                            + entry.getComment());
                }
            }
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void getSubscription() {
        try {
            GetSubscriptionResult getSubscriptionResult = datahubClient.getSubscription(Constant.projectName, Constant.topicName, subId);
            System.out.println(getSubscriptionResult.getSubId() + "\t"
                    + getSubscriptionResult.getState() + "\t"
                    + getSubscriptionResult.getType() + "\t"
                    + getSubscriptionResult.getComment());
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic or subscription not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateSubscriptionState() {
        try {
            datahubClient.updateSubscriptionState(Constant.projectName, Constant.topicName, subId, SubscriptionState.ONLINE);
            System.out.println("update subscription state successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic or subscription not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) {
        init();

        createSubscription();

//        updateSubscription();
//
//        listSubscription();
//
//        getSubscription();
//
//        updateSubscriptionState();
//
//        deleteSubscription();
    }
}
