package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.*;
import com.aliyun.datahub.client.model.*;

//Topic操作示例
public class TopicExample {
    private static DatahubClient datahubClient;
    private static RecordSchema recordSchema;


    public static void init() {
        // 创建DataHubClient实例
        datahubClient = DatahubClientBuilder.newBuilder()
                .setDatahubConfig(
                        new DatahubConfig(Constant.endpoint,
                                // 是否开启二进制传输，服务端2.12版本开始支持
                                new AliyunAccount(Constant.accessId, Constant.accessKey), true))
                .build();

        //定义schema
        recordSchema = new RecordSchema() {{
            addField(new Field("bigint_field", FieldType.BIGINT));
            addField(new Field("timestamp_field", FieldType.TIMESTAMP));
            addField(new Field("string_field", FieldType.STRING));
            addField(new Field("double_field", FieldType.DOUBLE));
            addField(new Field("boolean_field", FieldType.BOOLEAN));
            addField(new Field("decimal_field", FieldType.DECIMAL));
        }};
    }

    public static void createTupleTopic() {
        try {
            datahubClient.createTopic(Constant.projectName, Constant.topicName, Constant.shardCount, Constant.lifeCycle, RecordType.TUPLE, recordSchema, Constant.topicComment);
            System.out.println("create topic successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceAlreadyExistException e) {
            System.out.println("topic already exists, please check if it is consistent");
        } catch (ResourceNotFoundException e) {
            // project not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }


    public static void createBlobTopic() {

        try {
            datahubClient.createTopic(Constant.projectName, Constant.blobTopicName, Constant.shardCount, Constant.lifeCycle, RecordType.BLOB, Constant.topicComment);
            System.out.println("create topic successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceAlreadyExistException e) {
            System.out.println("topic already exists, please check if it is consistent");
        } catch (ResourceNotFoundException e) {
            // project not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void deleteTopic() {

        try {
            datahubClient.deleteTopic(Constant.projectName, Constant.topicName);
            System.out.println("delete topic successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }

    }

    public static void updateTopic() {
        try {
            String newComment = "new topic comment";
            datahubClient.updateTopic(Constant.projectName, Constant.topicName, newComment);
            System.out.println("update topic successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void listTopic() {
        try {
            datahubClient.deleteTopic(Constant.projectName, Constant.topicName);
            ListTopicResult listTopicResult = datahubClient.listTopic(Constant.projectName);
            if (listTopicResult.getTopicNames().size() > 0) {
                for (String tName : listTopicResult.getTopicNames()) {
                    System.out.println(tName);
                }
            }
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void getTopic() {
        try {
            GetTopicResult getTopicResult = datahubClient.getTopic(Constant.projectName, Constant.topicName);
            System.out.println(getTopicResult.getShardCount() + "\t"
                    + getTopicResult.getLifeCycle() + "\t"
                    + getTopicResult.getRecordType() + "\t"
                    + getTopicResult.getComment());
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }


    public static void appendNewField() {
        try {
            Field newField = new Field("newField", FieldType.STRING, true);
            datahubClient.appendField(Constant.projectName, Constant.topicName, newField);
            System.out.println("append field successful");
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) {
        init();

        createTupleTopic();
        createBlobTopic();
//        updateTopic();
//        listTopic();
//        getTopic();
//        appendNewField();
//        deleteTopic();
    }
}
