package com.aliyun.datahub.client.http.common;

import static com.aliyun.datahub.client.http.common.Constants.CONTENT_FORM;
import static com.aliyun.datahub.client.http.common.Constants.CONTENT_JSON;

public class HttpEntity<T> {

    private T entity;
    private String contentType;

    private HttpEntity(T entity, String contentType) {
        this.entity = entity;
        this.contentType = contentType;
    }

    public static <T> HttpEntity<T> json(T entity) {
        return new HttpEntity<>(entity, CONTENT_JSON);
    }

    public static HttpEntity<HttpForm> form(HttpForm form) {
        return new HttpEntity<>(form, CONTENT_FORM);
    }

    public T getEntity() {
        return entity;
    }

    public String getContentType() {
        return contentType;
    }
}
