package com.aliyun.datahub.client.http.common;

import java.util.Objects;

public class HttpRequestConfig {
    private int readTimeout = 10000;
    private int connTimeout = 10000;

    public int getReadTimeout() {
        return readTimeout;
    }

    public HttpRequestConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getConnTimeout() {
        return connTimeout;
    }

    public HttpRequestConfig setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HttpRequestConfig that = (HttpRequestConfig) o;
        return readTimeout == that.readTimeout &&
                connTimeout == that.connTimeout;
    }

    @Override
    public int hashCode() {
        return Objects.hash(readTimeout, connTimeout);
    }
}
