package com.aliyun.datahub.client.http.interceptor;

import okhttp3.Response;
import okhttp3.internal.http2.StreamResetException;

import java.io.IOException;

public class Http2RetryInterceptor extends HttpInterceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        // retry once for StreamResetException
        try {
            return chain.proceed(chain.request());
        } catch (StreamResetException ignored) {
            return chain.proceed(chain.request());
        }
    }
}
