package com.aliyun.datahub.client.impl;

import com.aliyun.datahub.client.common.DatahubConstant;
import com.aliyun.datahub.client.impl.request.AppendConnectorFieldRequest;
import com.aliyun.datahub.client.impl.request.AppendFieldRequest;
import com.aliyun.datahub.client.impl.request.CommitSubscriptionOffsetRequest;
import com.aliyun.datahub.client.impl.request.CreateAlarmRuleRequest;
import com.aliyun.datahub.client.impl.request.CreateConnectorRequest;
import com.aliyun.datahub.client.impl.request.CreateProjectRequest;
import com.aliyun.datahub.client.impl.request.CreateSubscriptionRequest;
import com.aliyun.datahub.client.impl.request.CreateTopicRequest;
import com.aliyun.datahub.client.impl.request.ExtendShardRequest;
import com.aliyun.datahub.client.impl.request.GetConnectorShardStatusRequest;
import com.aliyun.datahub.client.impl.request.GetCursorRequest;
import com.aliyun.datahub.client.impl.request.GetMeterInfoRequest;
import com.aliyun.datahub.client.impl.request.GetRecordsRequest;
import com.aliyun.datahub.client.impl.request.GetSubscriptionOffsetRequest;
import com.aliyun.datahub.client.impl.request.HeartbeatRequest;
import com.aliyun.datahub.client.impl.request.JoinGroupRequest;
import com.aliyun.datahub.client.impl.request.LeaveGroupRequest;
import com.aliyun.datahub.client.impl.request.ListAlarmRuleRequest;
import com.aliyun.datahub.client.impl.request.ListSubscriptionRequest;
import com.aliyun.datahub.client.impl.request.MergeShardRequest;
import com.aliyun.datahub.client.impl.request.OpenSubscriptionSessionRequest;
import com.aliyun.datahub.client.impl.request.PutRecordsRequest;
import com.aliyun.datahub.client.impl.request.ReloadConnectorRequest;
import com.aliyun.datahub.client.impl.request.ResetSubscriptionOffsetRequest;
import com.aliyun.datahub.client.impl.request.SplitShardRequest;
import com.aliyun.datahub.client.impl.request.SyncGroupRequest;
import com.aliyun.datahub.client.impl.request.UpdateAlarmRuleRequest;
import com.aliyun.datahub.client.impl.request.UpdateConnectorOffsetRequest;
import com.aliyun.datahub.client.impl.request.UpdateConnectorRequest;
import com.aliyun.datahub.client.impl.request.UpdateConnectorStateRequest;
import com.aliyun.datahub.client.impl.request.UpdateProjectRequest;
import com.aliyun.datahub.client.impl.request.UpdateProjectVpcWhiteListRequest;
import com.aliyun.datahub.client.impl.request.UpdateSubscriptionRequest;
import com.aliyun.datahub.client.impl.request.UpdateTopicRequest;
import com.aliyun.datahub.client.impl.request.protobuf.GetBatchRecordsRequestPB;
import com.aliyun.datahub.client.impl.request.protobuf.GetRecordsRequestPB;
import com.aliyun.datahub.client.impl.request.protobuf.PutBatchRecordsRequestPB;
import com.aliyun.datahub.client.impl.request.protobuf.PutRecordsRequestPB;
import com.aliyun.datahub.client.model.AppendConnectorFieldResult;
import com.aliyun.datahub.client.model.AppendFieldResult;
import com.aliyun.datahub.client.model.CommitSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.ConnectorShardStatusEntry;
import com.aliyun.datahub.client.model.CreateAlarmRuleResult;
import com.aliyun.datahub.client.model.CreateConnectorResult;
import com.aliyun.datahub.client.model.CreateProjectResult;
import com.aliyun.datahub.client.model.CreateSubscriptionResult;
import com.aliyun.datahub.client.model.CreateTopicResult;
import com.aliyun.datahub.client.model.DeleteAlarmRuleResult;
import com.aliyun.datahub.client.model.DeleteConnectorResult;
import com.aliyun.datahub.client.model.DeleteProjectResult;
import com.aliyun.datahub.client.model.DeleteSubscriptionResult;
import com.aliyun.datahub.client.model.DeleteTopicResult;
import com.aliyun.datahub.client.model.ExtendShardResult;
import com.aliyun.datahub.client.model.GetAlarmRuleResult;
import com.aliyun.datahub.client.model.GetConnectorDoneTimeResult;
import com.aliyun.datahub.client.model.GetConnectorResult;
import com.aliyun.datahub.client.model.GetConnectorShardStatusResult;
import com.aliyun.datahub.client.model.GetCursorResult;
import com.aliyun.datahub.client.model.GetMeterInfoResult;
import com.aliyun.datahub.client.model.GetProjectResult;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.GetSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.GetSubscriptionResult;
import com.aliyun.datahub.client.model.GetTopicResult;
import com.aliyun.datahub.client.model.HeartbeatResult;
import com.aliyun.datahub.client.model.JoinGroupResult;
import com.aliyun.datahub.client.model.LeaveGroupResult;
import com.aliyun.datahub.client.model.ListAlarmRuleResult;
import com.aliyun.datahub.client.model.ListConnectorResult;
import com.aliyun.datahub.client.model.ListProjectResult;
import com.aliyun.datahub.client.model.ListShardResult;
import com.aliyun.datahub.client.model.ListSubscriptionResult;
import com.aliyun.datahub.client.model.ListTopicResult;
import com.aliyun.datahub.client.model.MergeShardResult;
import com.aliyun.datahub.client.model.OpenSubscriptionSessionResult;
import com.aliyun.datahub.client.model.PutRecordsByShardResult;
import com.aliyun.datahub.client.model.PutRecordsResult;
import com.aliyun.datahub.client.model.ReloadConnectorResult;
import com.aliyun.datahub.client.model.ResetSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.SplitShardResult;
import com.aliyun.datahub.client.model.SyncGroupResult;
import com.aliyun.datahub.client.model.UpdateAlarmRuleResult;
import com.aliyun.datahub.client.model.UpdateConnectorOffsetResult;
import com.aliyun.datahub.client.model.UpdateConnectorResult;
import com.aliyun.datahub.client.model.UpdateConnectorStateResult;
import com.aliyun.datahub.client.model.UpdateProjectResult;
import com.aliyun.datahub.client.model.UpdateProjectVpcWhitelistResult;
import com.aliyun.datahub.client.model.UpdateSubscriptionResult;
import com.aliyun.datahub.client.model.UpdateSubscriptionStateResult;
import com.aliyun.datahub.client.model.UpdateTopicResult;
import com.aliyun.datahub.client.model.protobuf.GetBatchRecordsResultPB;
import com.aliyun.datahub.client.model.protobuf.GetRecordsResultPB;
import com.aliyun.datahub.client.model.protobuf.PutRecordsResultPB;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface DataHubService {
    @GET("projects")
    Call<ListProjectResult> listProject(@Query("filter") String filter);

    @GET("projects/{projectName}")
    Call<GetProjectResult> getProject(@Path("projectName") String projectName);

    @POST("projects/{projectName}")
    Call<CreateProjectResult> createProject(@Path("projectName") String projectName, @Body CreateProjectRequest request);

    @PUT("projects/{projectName}")
    Call<UpdateProjectResult> updateProject(@Path("projectName") String projectName, @Body UpdateProjectRequest request);

    @PUT("projects/{projectName}")
    Call<UpdateProjectVpcWhitelistResult> updateProject(@Path("projectName") String projectName, @Body UpdateProjectVpcWhiteListRequest request);

    @DELETE("projects/{projectName}")
    Call<DeleteProjectResult> deleteProject(@Path("projectName") String projectName);

    @POST("projects/{projectName}/topics/{topicName}")
    Call<CreateTopicResult> createTopic(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                        @Body CreateTopicRequest request);

    @PUT("projects/{projectName}/topics/{topicName}")
    Call<UpdateTopicResult> updateTopic(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                        @Body UpdateTopicRequest request);

    @GET("projects/{projectName}/topics/{topicName}")
    Call<GetTopicResult> getTopic(@Path("projectName") String projectName, @Path("topicName") String topicName);

    @DELETE("projects/{projectName}/topics/{topicName}")
    Call<DeleteTopicResult> deleteTopic(@Path("projectName") String projectName, @Path("topicName") String topicName);

    @GET("projects/{projectName}/topics")
    Call<ListTopicResult> listTopic(@Path("projectName") String projectName, @Query("filter") String filter);

    @GET("projects/{projectName}/topics/{topicName}/shards")
    Call<ListShardResult> listShard(@Path("projectName") String projectName, @Path("topicName") String topicName);

    @POST("projects/{projectName}/topics/{topicName}/shards")
    Call<SplitShardResult> splitShard(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                      @Body SplitShardRequest request);

    @POST("projects/{projectName}/topics/{topicName}/shards")
    Call<MergeShardResult> mergeShard(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                      @Body MergeShardRequest request);

    @POST("projects/{projectName}/topics/{topicName}/shards")
    Call<ExtendShardResult> extendShard(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                        @Body ExtendShardRequest request);

    @POST("projects/{projectName}/topics/{topicName}/shards/{shardId}")
    Call<GetCursorResult> getCursor(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                    @Path("shardId") String shardId,
                                    @Body GetCursorRequest request);

    @POST("projects/{projectName}/topics/{topicName}/shards")
    Call<PutRecordsResult> putRecords(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                      @Body PutRecordsRequest request);

    @POST("projects/{projectName}/topics/{topicName}/shards")
    @Headers(DatahubConstant.X_DATAHUB_REQUEST_ACTION + ":pub")
    Call<PutRecordsResultPB> putPbRecords(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                          @Body PutRecordsRequestPB request);

    @POST("projects/{projectName}/topics/{topicName}/shards/{shardId}")
    @Headers(DatahubConstant.X_DATAHUB_REQUEST_ACTION + ":pub")
    Call<PutRecordsByShardResult> putPbRecordsByShard(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                      @Path("shardId") String shardId, @Body PutRecordsRequestPB request);

    @POST("projects/{projectName}/topics/{topicName}/shards/{shardId}")
    @Headers(DatahubConstant.X_DATAHUB_REQUEST_ACTION + ":pub")
    Call<PutRecordsByShardResult> putBatchRecordsByShard(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                         @Path("shardId") String shardId, @Body PutBatchRecordsRequestPB request);

    @POST("projects/{projectName}/topics/{topicName}/shards/{shardId}")
    Call<GetRecordsResult> getRecords(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                      @Path("shardId") String shardId, @Body GetRecordsRequest request);

    @POST("projects/{projectName}/topics/{topicName}/shards/{shardId}")
    @Headers(DatahubConstant.X_DATAHUB_REQUEST_ACTION + ":sub")
    Call<GetRecordsResultPB> getPBRecords(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                          @Path("shardId") String shardId, @Body GetRecordsRequestPB request);

    @POST("projects/{projectName}/topics/{topicName}/shards/{shardId}")
    @Headers(DatahubConstant.X_DATAHUB_REQUEST_ACTION + ":sub")
    Call<GetBatchRecordsResultPB> getBatchRecords(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                  @Path("shardId") String shardId, @Body GetBatchRecordsRequestPB request);

    @POST("projects/{projectName}/topics/{topicName}")
    Call<AppendFieldResult> appendField(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                        @Body AppendFieldRequest request);

    @POST("projects/{projectName}/topics/{topicName}/shards/{shardId}")
    Call<GetMeterInfoResult> getMeterInfo(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                          @Path("shardId") String shardId,
                                          @Body GetMeterInfoRequest request);

    @GET("projects/{projectName}/topics/{topicName}/connectors?mode=id")
    Call<ListConnectorResult> listConnector(@Path("projectName") String projectName, @Path("topicName") String topicName);

    @POST("projects/{projectName}/topics/{topicName}/connectors/{connectorType}")
    Call<CreateConnectorResult> createConnector(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                @Path("connectorType") String connectorType,
                                                @Body CreateConnectorRequest request);

    @GET("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<GetConnectorResult> getConnector(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                          @Path("connectorId") String connectorId);

    @POST("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<UpdateConnectorResult> updateConnector(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                @Path("connectorId") String connectorId, @Body UpdateConnectorRequest request);

    @DELETE("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<DeleteConnectorResult> deleteConnector(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                @Path("connectorId") String connectorId);

    @GET("projects/{projectName}/topics/{topicName}/connectors/{connectorId}?donetime")
    Call<GetConnectorDoneTimeResult> getConnectorDoneTime(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                          @Path("connectorId") String connectorId);

    @POST("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<ReloadConnectorResult> reloadConnector(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                @Path("connectorId") String connectorId, @Body ReloadConnectorRequest request);

    @POST("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<UpdateConnectorStateResult> updateConnectorState(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                          @Path("connectorId") String connectorId, @Body UpdateConnectorStateRequest request);

    @POST("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<UpdateConnectorOffsetResult> updateConnectorOffset(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                            @Path("connectorId") String connectorId, @Body UpdateConnectorOffsetRequest request);

    @POST("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<GetConnectorShardStatusResult> getConnectorShardStatus(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                                @Path("connectorId") String connectorId, @Body GetConnectorShardStatusRequest request);

    @POST("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<ConnectorShardStatusEntry> getConnectorShardStatusByShard(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                                   @Path("connectorId") String connectorId, @Body GetConnectorShardStatusRequest request);

    @POST("projects/{projectName}/topics/{topicName}/connectors/{connectorId}")
    Call<AppendConnectorFieldResult> appendConnectorField(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                          @Path("connectorId") String connectorId, @Body AppendConnectorFieldRequest request);

    @POST("projects/{projectName}/topics/{topicName}/subscriptions")
    Call<CreateSubscriptionResult> createSubscription(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                      @Body CreateSubscriptionRequest request);

    @GET("projects/{projectName}/topics/{topicName}/subscriptions/{subId}")
    Call<GetSubscriptionResult> getSubscription(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                @Path("subId") String subId);

    @DELETE("projects/{projectName}/topics/{topicName}/subscriptions/{subId}")
    Call<DeleteSubscriptionResult> deleteSubscription(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                      @Path("subId") String subId);

    @POST("projects/{projectName}/topics/{topicName}/subscriptions")
    Call<ListSubscriptionResult> listSubscription(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                  @Body ListSubscriptionRequest request);

    @PUT("projects/{projectName}/topics/{topicName}/subscriptions/{subId}")
    Call<UpdateSubscriptionResult> updateSubscription(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                      @Path("subId") String subId, @Body UpdateSubscriptionRequest request);

    @PUT("projects/{projectName}/topics/{topicName}/subscriptions/{subId}")
    Call<UpdateSubscriptionStateResult> updateSubscriptionState(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                                @Path("subId") String subId, @Body UpdateSubscriptionRequest request);

    @POST("projects/{projectName}/topics/{topicName}/subscriptions/{subId}/offsets")
    Call<OpenSubscriptionSessionResult> openSubscriptionSession(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                                @Path("subId") String subId, @Body OpenSubscriptionSessionRequest request);

    @POST("projects/{projectName}/topics/{topicName}/subscriptions/{subId}/offsets")
    Call<GetSubscriptionOffsetResult> getSubscriptionOffset(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                            @Path("subId") String subId, @Body GetSubscriptionOffsetRequest request);

    @PUT("projects/{projectName}/topics/{topicName}/subscriptions/{subId}/offsets")
    Call<CommitSubscriptionOffsetResult> commitSubscriptionOffset(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                                  @Path("subId") String subId, @Body CommitSubscriptionOffsetRequest request);

    @PUT("projects/{projectName}/topics/{topicName}/subscriptions/{subId}/offsets")
    Call<ResetSubscriptionOffsetResult> resetSubscriptionOffset(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                                @Path("subId") String subId, @Body ResetSubscriptionOffsetRequest request);

    @POST("projects/{projectName}/topics/{topicName}/subscriptions/{consumerGroup}")
    Call<HeartbeatResult> heartbeat(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                    @Path("consumerGroup") String consumerGroup, @Body HeartbeatRequest request);

    @POST("projects/{projectName}/topics/{topicName}/subscriptions/{consumerGroup}")
    Call<JoinGroupResult> joinGroup(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                    @Path("consumerGroup") String consumerGroup, @Body JoinGroupRequest request);

    @POST("projects/{projectName}/topics/{topicName}/subscriptions/{consumerGroup}")
    Call<SyncGroupResult> syncGroup(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                    @Path("consumerGroup") String consumerGroup, @Body SyncGroupRequest request);

    @POST("projects/{projectName}/topics/{topicName}/subscriptions/{consumerGroup}")
    Call<LeaveGroupResult> leaveGroup(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                      @Path("consumerGroup") String consumerGroup, @Body LeaveGroupRequest request);

    @POST("projects/{projectName}/topics/{topicName}/alarms")
    Call<CreateAlarmRuleResult> createAlarmRule(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                @Body CreateAlarmRuleRequest request);

    @PUT("projects/{projectName}/topics/{topicName}/alarms/{alarmId}")
    Call<UpdateAlarmRuleResult> updateAlarmRule(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                @Path("alarmId") String alarmId, @Body UpdateAlarmRuleRequest request);

    @GET("projects/{projectName}/topics/{topicName}/alarms/{alarmId}")
    Call<GetAlarmRuleResult> getAlarmRule(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                          @Path("alarmId") String alarmId);

    @DELETE("projects/{projectName}/topics/{topicName}/alarms/{alarmId}")
    Call<DeleteAlarmRuleResult> deleteAlarmRule(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                                @Path("alarmId") String alarmId);

    @POST("projects/{projectName}/topics/{topicName}/alarms")
    Call<ListAlarmRuleResult> listAlarmRule(@Path("projectName") String projectName, @Path("topicName") String topicName,
                                            @Body ListAlarmRuleRequest request);
}
