package com.aliyun.datahub.client.impl.request;

import com.aliyun.datahub.client.model.ConnectorConfig;
import com.aliyun.datahub.client.model.ConnectorType;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

public class CreateConnectorRequest extends BaseRequest {
    @JsonProperty("Type")
    private ConnectorType type;

    @JsonProperty("SinkStartTime")
    private long sinkStartTime;

    @JsonProperty("ColumnFields")
    private List<String> columnFields;

    @JsonProperty("ColumnNameMap")
    private Map<String, String> columnNameMap;

    @JsonProperty("Config")
    private ConnectorConfig config;

    public CreateConnectorRequest() {
        setAction("Create");
    }

    public ConnectorType getType() {
        return type;
    }

    public CreateConnectorRequest setType(ConnectorType type) {
        this.type = type;
        return this;
    }

    public long getSinkStartTime() {
        return sinkStartTime;
    }

    public CreateConnectorRequest setSinkStartTime(long sinkStartTime) {
        this.sinkStartTime = sinkStartTime;
        return this;
    }

    public List<String> getColumnFields() {
        return columnFields;
    }

    public CreateConnectorRequest setColumnFields(List<String> columnFields) {
        this.columnFields = columnFields;
        return this;
    }

    public ConnectorConfig getConfig() {
        return config;
    }

    public CreateConnectorRequest setConfig(ConnectorConfig config) {
        this.config = config;
        return this;
    }

    public Map<String, String> getColumnNameMap() {
        return columnNameMap;
    }

    public CreateConnectorRequest setColumnNameMap(Map<String, String> columnNameMap) {
        this.columnNameMap = columnNameMap;
        return this;
    }
}
