package com.aliyun.datahub.client.impl.request;

import com.aliyun.datahub.client.model.ConnectorConfig;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

public class UpdateConnectorRequest extends BaseRequest {
    @JsonProperty("ColumnNameMap")
    private Map<String, String> columnNameMap;

    @JsonProperty("Config")
    private ConnectorConfig config;

    @JsonProperty("ColumnFields")
    private List<String> columnFields;

    public UpdateConnectorRequest() {
        setAction("updateconfig");
    }

    public ConnectorConfig getConfig() {
        return config;
    }

    public UpdateConnectorRequest setConfig(ConnectorConfig config) {
        this.config = config;
        return this;
    }

    public Map<String, String> getColumnNameMap() {
        return columnNameMap;
    }

    public UpdateConnectorRequest setColumnNameMap(Map<String, String> columnNameMap) {
        this.columnNameMap = columnNameMap;
        return this;
    }

    public List<String> getColumnFields() {
        return columnFields;
    }

    public UpdateConnectorRequest setColumnFields(List<String> columnFields) {
        this.columnFields = columnFields;
        return this;
    }
}
