package com.aliyun.datahub.client.impl.request.protobuf;

import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.http.converter.batch.BatchUtil;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.protobuf.DatahubProtos;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;

import java.util.List;

import static com.aliyun.datahub.client.http.common.Constants.CONTENT_BINARY;

public class PutBatchRecordsRequestPB implements BaseProtobufModel {
    private DatahubProtos.PutBinaryRecordsRequest.Builder reqBuilder = DatahubProtos.PutBinaryRecordsRequest.newBuilder();
    private HttpConfig.CompressType compressType;

    public PutBatchRecordsRequestPB(HttpConfig.CompressType compressType) {
        this.compressType = compressType;
    }

    public PutBatchRecordsRequestPB setRecords(List<RecordEntry> records) {
        byte[] batchBuffer = BatchUtil.serialize(records, this.compressType);
        DatahubProtos.BinaryRecordEntry.Builder recordBuilder = DatahubProtos.BinaryRecordEntry.newBuilder();
        recordBuilder.setData(ByteString.copyFrom(batchBuffer));
        reqBuilder.addRecords(recordBuilder.build());
        return this;
    }

    @Override
    public Message getMessage() {
        return reqBuilder.build();
    }

    @Override
    public void setMessage(Message message) {
    }

    @Override
    public String getContentType() {
        return CONTENT_BINARY;
    }
}
