package com.aliyun.datahub.client.impl.serializer;

import com.aliyun.datahub.client.model.AlarmLevel;
import com.aliyun.datahub.client.model.AlarmRule;
import com.aliyun.datahub.client.model.AlarmRuleEntry;
import com.aliyun.datahub.client.model.AlarmType;
import com.aliyun.datahub.client.model.ConnectorDoneDelayAlarmRule;
import com.aliyun.datahub.client.model.SubReadDelayAlarmRule;
import com.aliyun.datahub.client.model.TopicNoDataAlarmRule;
import com.aliyun.datahub.client.util.JsonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlarmRuleEntryDeserializer extends JsonDeserializer<AlarmRuleEntry> {
    @Override
    public AlarmRuleEntry deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        AlarmRuleEntry result = new AlarmRuleEntry();
        deserialize(result, jsonParser);
        return result;
    }

    public static void deserialize(AlarmRuleEntry alarmRuleEntry, JsonParser jsonParser) throws IOException, JsonProcessingException {
        JsonNode tree = jsonParser.getCodec().readTree(jsonParser);
        JsonNode node = tree.get("RegionId");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setRegionId(node.asText());
        }
        node = tree.get("AlarmId");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setAlarmId(node.asText());
        }
        node = tree.get("ProjectName");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setProjectName(node.asText());
        }
        node = tree.get("TopicName");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setTopicName(node.asText());
        }
        node = tree.get("Uid");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setUid(node.asText());
        }
        node = tree.get("AlarmType");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setAlarmType(AlarmType.fromString(node.asText()));
        }
        node = tree.get("CreateTime");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setCreateTime(node.asInt());
        }
        node = tree.get("UpdateTime");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setUpdateTime(node.asInt());
        }
        node = tree.get("Rule");
        if (node != null && !node.isNull()) {
            alarmRuleEntry.setRule(deserializeAlarmRule(alarmRuleEntry.getAlarmType(), node));
        }
        node = tree.get("Config");
        if (node != null && node.isObject()) {
            Map<String, String> config = new HashMap<>();
            Iterator<Map.Entry<String, JsonNode>> iter = node.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                if (entry.getValue() != null && entry.getValue().isTextual()) {
                    config.put(entry.getKey(), entry.getValue().asText());
                }
            }
            alarmRuleEntry.setConfig(config);
        }
    }

    private static AlarmRule deserializeAlarmRule(AlarmType type, JsonNode tree) throws IOException {
        AlarmRule alarmRule;
        if (AlarmType.USER_TOPIC_NO_DATA.equals(type)) {
            alarmRule = deserializeTopicNoDataAlarmRule(tree);
        } else if (AlarmType.USER_SUB_READ_DELAY.equals(type)) {
            alarmRule = deserializeSubReadDelayAlarmRule(tree);
        } else if (AlarmType.USER_CONNECTOR_DONE_DELAY.equals(type)) {
            alarmRule = deserializeConnectorDoneDelayAlarmRule(tree);
        } else {
            throw new IOException("unknown alarm type");
        }

        JsonNode node = tree.get("Level");
        if (node != null && !node.isNull()) {
            alarmRule.setLevel(AlarmLevel.fromString(node.asText()));
        }
        node = tree.get("Phone");
        if (node != null && node.isTextual()) {
            JsonNode fNode = JsonUtils.toJsonNode(node.asText());
            if (fNode != null && fNode.isArray()) {
                List<String> phoneList = new ArrayList<>();
                for (JsonNode temp : fNode) {
                    phoneList.add(temp.asText());
                }
                alarmRule.setPhoneList(phoneList);
            }
        }
        node = tree.get("Mail");
        if (node != null && node.isTextual()) {
            JsonNode fNode = JsonUtils.toJsonNode(node.asText());
            if (fNode != null && fNode.isArray()) {
                List<String> mailList = new ArrayList<>();
                for (JsonNode temp : fNode) {
                    mailList.add(temp.asText());
                }
                alarmRule.setMailList(mailList);
            }
        }
        node = tree.get("EmpId");
        if (node != null && node.isTextual()) {
            JsonNode fNode = JsonUtils.toJsonNode(node.asText());
            if (fNode != null && fNode.isArray()) {
                List<String> empIdList = new ArrayList<>();
                for (JsonNode temp : fNode) {
                    empIdList.add(temp.asText());
                }
                alarmRule.setEmpIdList(empIdList);
            }
        }
        return alarmRule;
    }

    private static AlarmRule deserializeTopicNoDataAlarmRule(JsonNode tree) {
        TopicNoDataAlarmRule alarmRule = new TopicNoDataAlarmRule();
        JsonNode node = tree.get("SuspendSecond");
        if (node != null && !node.isNull()) {
            alarmRule.setSuspendSecond(Integer.parseInt(node.asText()));
        }
        return alarmRule;
    }

    private static AlarmRule deserializeSubReadDelayAlarmRule(JsonNode tree) {
        SubReadDelayAlarmRule alarmRule = new SubReadDelayAlarmRule();
        JsonNode node = tree.get("SubId");
        if (node != null && !node.isNull()) {
            alarmRule.setSubId(node.asText());
        }
        node = tree.get("DelaySecond");
        if (node != null && !node.isNull()) {
            alarmRule.setDelaySecond(Integer.parseInt(node.asText()));
        }
        return alarmRule;
    }

    private static AlarmRule deserializeConnectorDoneDelayAlarmRule(JsonNode tree) {
        ConnectorDoneDelayAlarmRule alarmRule = new ConnectorDoneDelayAlarmRule();
        JsonNode node = tree.get("ConnectorId");
        if (node != null && !node.isNull()) {
            alarmRule.setConnectorId(node.asText());
        }
        node = tree.get("DelaySecond");
        if (node != null && !node.isNull()) {
            alarmRule.setDelaySecond(Integer.parseInt(node.asText()));
        }
        return alarmRule;
    }
}