package com.aliyun.datahub.client.impl.serializer;

import com.aliyun.datahub.client.impl.request.AppendFieldRequest;
import com.aliyun.datahub.client.model.Field;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;

public class AppendFieldRequestSerializer extends JsonSerializer<AppendFieldRequest> {
    @Override
    public void serialize(AppendFieldRequest appendFieldRequest, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();

        jsonGenerator.writeStringField("Action", appendFieldRequest.getAction());
        if (appendFieldRequest.getFields() != null) {
            jsonGenerator.writeArrayFieldStart("Fields");
            for (Field field : appendFieldRequest.getFields()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("Name", field.getName());
                jsonGenerator.writeStringField("Type", field.getType().name());
                jsonGenerator.writeStringField("Comment", field.getComment());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeStringField("FieldName", appendFieldRequest.getFieldName());
            jsonGenerator.writeStringField("FieldType", appendFieldRequest.getFieldType().name());
        }
        jsonGenerator.writeEndObject();
    }
}
