package com.aliyun.datahub.client.model;

import com.aliyun.datahub.client.impl.serializer.AlarmRuleSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.List;

@JsonSerialize(using = AlarmRuleSerializer.class)
public abstract class AlarmRule {
    protected AlarmType alarmType;
    protected List<String> phoneList;
    protected List<String> mailList;
    protected AlarmLevel level;

    AlarmRule(AlarmType alarmType) {
        this.alarmType = alarmType;
    }

    public AlarmType getAlarmType() {
        return alarmType;
    }

    public List<String> getPhoneList() {
        return phoneList;
    }

    public void setPhoneList(List<String> phoneList) {
        this.phoneList = phoneList;
    }

    public List<String> getMailList() {
        return mailList;
    }

    public void setMailList(List<String> mailList) {
        this.mailList = mailList;
    }

    public AlarmLevel getLevel() {
        return level;
    }

    public void setLevel(AlarmLevel level) {
        this.level = level;
    }

    public String getExtraResource() { return null; }

    public String getExtraResourceName() { return null; }

    /********************
     * for internal use
     ********************/
    protected List<String> empIdList;


    public List<String> getEmpIdList() {
        return empIdList;
    }

    public void setEmpIdList(List<String> empIdList) {
        this.empIdList = empIdList;
    }
}
