package com.aliyun.datahub.client.model;

import com.aliyun.datahub.client.impl.serializer.ConnectorConfigSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using = ConnectorConfigSerializer.class)
public abstract class ConnectorConfig {
    public enum TimestampUnit {
        /**
         * Unit: Microsecond
         */
        MICROSECOND,
        /**
         * Unit: Millisecond
         */
        MILLISECOND,
        /**
         * Unit: Second
         */
        SECOND,
    }

    private TimestampUnit timestampUnit = TimestampUnit.MICROSECOND;

    public TimestampUnit getTimestampUnit() {
        return timestampUnit;
    }

    public void setTimestampUnit(TimestampUnit timestampUnit) {
        this.timestampUnit = timestampUnit;
    }
}
