package com.aliyun.datahub.client.model;

import com.aliyun.datahub.client.impl.serializer.GetConnectorResultDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.util.List;
import java.util.Map;

@JsonDeserialize(using = GetConnectorResultDeserializer.class)
public class GetConnectorResult extends BaseResult {
    private String clusterAddr;
    private String connectorId;
    private String creator;
    private long createTime;
    private long lastModifyTime;
    private ConnectorType type;
    private ConnectorState state;
    private List<String> columnFields;
    private Map<String, String> columnNameMap;
    private ConnectorConfig config;
    private Map<String, String> extraConfig;

    @Deprecated
    private List<ShardContext> shardContexts;
    private String subId;

    public String getClusterAddr() {
        return clusterAddr;
    }

    public void setClusterAddr(String clusterAddr) {
        this.clusterAddr = clusterAddr;
    }

    public String getConnectorId() {
        return connectorId;
    }

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getLastModifyTime() {
        return lastModifyTime;
    }

    public void setLastModifyTime(long lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public ConnectorType getType() {
        return type;
    }

    public void setType(ConnectorType type) {
        this.type = type;
    }

    public ConnectorState getState() {
        return state;
    }

    public void setState(ConnectorState state) {
        this.state = state;
    }

    public List<String> getColumnFields() {
        return columnFields;
    }

    public void setColumnFields(List<String> columnFields) {
        this.columnFields = columnFields;
    }

    public Map<String, String> getColumnNameMap() {
        return columnNameMap;
    }

    public void setColumnNameMap(Map<String, String> columnNameMap) {
        this.columnNameMap = columnNameMap;
    }

    public ConnectorConfig getConfig() {
        return config;
    }

    public void setConfig(ConnectorConfig config) {
        this.config = config;
    }

    @Deprecated
    public List<ShardContext> getShardContexts() {
        return shardContexts;
    }

    @Deprecated
    public void setShardContexts(List<ShardContext> shardContexts) {
        this.shardContexts = shardContexts;
    }

    public String getSubId() {
        return subId;
    }

    public void setSubId(String subId) {
        this.subId = subId;
    }

    public Map<String, String> getExtraConfig() {
        return extraConfig;
    }

    public void setExtraConfig(Map<String, String> extraConfig) {
        this.extraConfig = extraConfig;
    }
}