package com.aliyun.datahub.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.HashMap;
import java.util.Map;

public class RecordEntry extends RecordRespMeta {
    @JsonProperty("ShardId")
    private String shardId;

    @JsonProperty("PartitionKey")
    private String partitionKey;

    @JsonProperty("HashKey")
    private String hashKey;

    @JsonProperty("Attributes")
    private Map<String, String> attributes;

    @JsonProperty("Data")
    private RecordData recordData;

    private RecordKey key;

    public void addAttribute(String key, String value) {
        if (attributes == null) {
            attributes = new HashMap<>();
        }
        attributes.put(key, value);
    }

    public String getShardId() {
        return shardId;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getPartitionKey() {
        return partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public String getHashKey() {
        return hashKey;
    }

    public void setHashKey(String hashKey) {
        this.hashKey = hashKey;
    }

    public Map<String, String> getAttributes() {
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public RecordData getRecordData() {
        return recordData;
    }

    public void setRecordData(RecordData recordData) {
        this.recordData = recordData;
    }

    public RecordKey getKey() {
        return key;
    }

    public void setKey(RecordKey key) {
        this.key = key;
    }
}
